/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc.antlr4;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.CompactConstructorDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumConstantDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithAnnotations;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.TypeParameter;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.control.ResolveVisitor;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyAbstractableElementDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyAnnotationRef;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyExecutableMemberDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyFieldDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyParameter;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyProgramElementDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyType;

public class GroovydocJavaVisitor
extends VoidVisitorAdapter<Object> {
    private final List<LinkArgument> links;
    private SimpleGroovyClassDoc currentClassDoc = null;
    private final Map<String, GroovyClassDoc> classDocs = new LinkedHashMap<String, GroovyClassDoc>();
    private final String packagePath;
    private final Map<String, String> aliases = new LinkedHashMap<String, String>();
    private final List<String> imports = new ArrayList<String>();
    private static final String FS = "/";

    public GroovydocJavaVisitor(String packagePath, List<LinkArgument> links) {
        this.packagePath = packagePath;
        this.links = links;
    }

    public void visit(ImportDeclaration n, Object arg) {
        Optional qualPath = n.getName().getQualifier();
        String qual = qualPath.map(value -> value.asString().replace('.', '/') + FS).orElse("");
        String id = n.getName().getIdentifier();
        String name = qual + id;
        if (n.isAsterisk()) {
            name = name + "/*";
        }
        this.imports.add(name);
        this.aliases.put(id, name);
        super.visit(n, arg);
    }

    private List<String> getImports() {
        ArrayList<String> imports = new ArrayList<String>(this.imports);
        imports.add(this.packagePath + "/*");
        for (String pkg : ResolveVisitor.DEFAULT_IMPORTS) {
            imports.add(pkg.replace('.', '/') + "*");
        }
        return imports;
    }

    public void visit(EnumDeclaration n, Object arg) {
        SimpleGroovyClassDoc parent = this.visit((TypeDeclaration<?>)n);
        this.currentClassDoc.setTokenType(61);
        super.visit(n, arg);
        if (parent != null) {
            this.currentClassDoc = parent;
        }
    }

    public void visit(EnumConstantDeclaration n, Object arg) {
        if (!this.currentClassDoc.isEnum()) {
            throw new GroovyBugError("Annotation member definition found when not expected");
        }
        String enumConstantName = n.getNameAsString();
        SimpleGroovyFieldDoc enumConstantDoc = new SimpleGroovyFieldDoc(enumConstantName, this.currentClassDoc);
        enumConstantDoc.setType(new SimpleGroovyType(this.currentClassDoc.getTypeDescription()));
        enumConstantDoc.setPublic(true);
        this.currentClassDoc.addEnumConstant(enumConstantDoc);
        this.processAnnotations(enumConstantDoc, (NodeWithAnnotations<?>)n);
        n.getJavadocComment().ifPresent(javadocComment -> enumConstantDoc.setRawCommentText(javadocComment.getContent()));
        super.visit(n, arg);
    }

    public void visit(AnnotationDeclaration n, Object arg) {
        SimpleGroovyClassDoc parent = this.visit((TypeDeclaration<?>)n);
        this.currentClassDoc.setTokenType(64);
        super.visit(n, arg);
        if (parent != null) {
            this.currentClassDoc.setPublic(true);
            this.currentClassDoc = parent;
        }
    }

    public void visit(AnnotationMemberDeclaration n, Object arg) {
        if (!this.currentClassDoc.isAnnotationType()) {
            throw new GroovyBugError("Annotation member definition found when not expected");
        }
        SimpleGroovyFieldDoc fieldDoc = new SimpleGroovyFieldDoc(n.getNameAsString(), this.currentClassDoc);
        fieldDoc.setType(this.makeType(n.getType()));
        this.setModifiers((NodeList<Modifier>)n.getModifiers(), fieldDoc);
        fieldDoc.setPublic(true);
        this.processAnnotations(fieldDoc, (NodeWithAnnotations<?>)n);
        this.currentClassDoc.add(fieldDoc);
        n.getJavadocComment().ifPresent(javadocComment -> fieldDoc.setRawCommentText(javadocComment.getContent()));
        n.getDefaultValue().ifPresent(defValue -> {
            fieldDoc.setRawCommentText(fieldDoc.getRawCommentText() + "\n* @default " + defValue);
            fieldDoc.setConstantValueExpression(defValue.toString());
        });
        super.visit(n, arg);
    }

    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        SimpleGroovyClassDoc parent = this.visit((TypeDeclaration<?>)n);
        if (n.isInterface()) {
            this.currentClassDoc.setTokenType(14);
        } else {
            this.currentClassDoc.setTokenType(13);
        }
        n.getExtendedTypes().forEach(et -> {
            if (n.isInterface()) {
                this.currentClassDoc.addInterfaceName(this.fullName((ClassOrInterfaceType)et));
            } else {
                this.currentClassDoc.setSuperClassName(this.fullName((ClassOrInterfaceType)et));
            }
        });
        if (!n.isInterface() && this.currentClassDoc.getSuperClassName() == null && this.currentClassDoc.superclass() == null) {
            this.currentClassDoc.setSuperClassName("Object");
        }
        this.currentClassDoc.setNameWithTypeArgs(this.currentClassDoc.name() + this.genericTypesAsString((NodeList<TypeParameter>)n.getTypeParameters()));
        n.getImplementedTypes().forEach(classOrInterfaceType -> this.currentClassDoc.addInterfaceName(this.fullName((ClassOrInterfaceType)classOrInterfaceType)));
        super.visit(n, arg);
        if (parent != null) {
            this.currentClassDoc = parent;
        }
    }

    public void visit(RecordDeclaration n, Object arg) {
        SimpleGroovyClassDoc parent = this.visit((TypeDeclaration<?>)n);
        if (n.isRecordDeclaration()) {
            this.currentClassDoc.setTokenType(16);
        }
        super.visit(n, arg);
        if (parent != null) {
            this.currentClassDoc = parent;
        }
    }

    public void visit(CompactConstructorDeclaration c, Object arg) {
        SimpleGroovyConstructorDoc meth = new SimpleGroovyConstructorDoc(c.getNameAsString(), this.currentClassDoc);
        this.setCompactConstructor(c, meth);
        this.currentClassDoc.add(meth);
        super.visit(c, arg);
    }

    private String fullName(ClassOrInterfaceType et) {
        StringBuilder name = new StringBuilder();
        et.getScope().ifPresent(sc -> name.append(sc.toString()));
        name.append(et.getNameAsString());
        return name.toString();
    }

    private String genericTypesAsString(NodeList<TypeParameter> typeParameters) {
        if (typeParameters == null || typeParameters.size() == 0) {
            return "";
        }
        return "<" + DefaultGroovyMethods.join(typeParameters, ", ") + ">";
    }

    private SimpleGroovyClassDoc visit(TypeDeclaration<?> n) {
        SimpleGroovyClassDoc parent = null;
        List<String> imports = this.getImports();
        String name = n.getNameAsString();
        if (n.isNestedType()) {
            parent = this.currentClassDoc;
            name = parent.name() + "$" + name;
        }
        this.currentClassDoc = new SimpleGroovyClassDoc(imports, this.aliases, name.replace('$', '.'), this.links);
        NodeList mods = n.getModifiers();
        if (parent != null) {
            parent.addNested(this.currentClassDoc);
            if (parent.isInterface()) {
                mods.add((Node)Modifier.publicModifier());
            }
        }
        this.setModifiers((NodeList<Modifier>)mods, this.currentClassDoc);
        this.processAnnotations(this.currentClassDoc, (NodeWithAnnotations<?>)n);
        this.currentClassDoc.setFullPathName(this.withSlashes(this.packagePath + FS + name));
        this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
        n.getJavadocComment().ifPresent(javadocComment -> this.currentClassDoc.setRawCommentText(javadocComment.getContent()));
        return parent;
    }

    private void processAnnotations(SimpleGroovyProgramElementDoc element, NodeWithAnnotations<?> n) {
        for (AnnotationExpr an : n.getAnnotations()) {
            element.addAnnotationRef(new SimpleGroovyAnnotationRef(an.getNameAsString(), this.getAnnotationText(an)));
        }
    }

    private void processAnnotations(SimpleGroovyParameter param, NodeWithAnnotations<?> n) {
        for (AnnotationExpr an : n.getAnnotations()) {
            param.addAnnotationRef(new SimpleGroovyAnnotationRef(an.getNameAsString(), this.getAnnotationText(an)));
        }
    }

    private String getAnnotationText(AnnotationExpr an) {
        if (an != null && an.getTokenRange().isPresent()) {
            return ((TokenRange)an.getTokenRange().get()).toString();
        }
        return "";
    }

    private void setModifiers(NodeList<Modifier> modifiers, SimpleGroovyAbstractableElementDoc elementDoc) {
        if (modifiers.contains((Node)Modifier.publicModifier())) {
            elementDoc.setPublic(true);
        }
        if (modifiers.contains((Node)Modifier.staticModifier())) {
            elementDoc.setStatic(true);
        }
        if (modifiers.contains((Node)Modifier.abstractModifier())) {
            elementDoc.setAbstract(true);
        }
        if (modifiers.contains((Node)Modifier.finalModifier())) {
            elementDoc.setFinal(true);
        }
        if (modifiers.contains((Node)Modifier.protectedModifier())) {
            elementDoc.setProtected(true);
        }
        if (modifiers.contains((Node)Modifier.privateModifier())) {
            elementDoc.setPrivate(true);
        }
    }

    private String withSlashes(String s) {
        return s.replace('.', '/').replace('$', '.');
    }

    public void visit(MethodDeclaration m, Object arg) {
        SimpleGroovyMethodDoc meth = new SimpleGroovyMethodDoc(m.getNameAsString(), this.currentClassDoc);
        meth.setTypeParameters(this.genericTypesAsString((NodeList<TypeParameter>)m.getTypeParameters()));
        meth.setReturnType(this.makeType(m.getType()));
        this.setConstructorOrMethodCommon((CallableDeclaration<? extends CallableDeclaration<?>>)m, meth);
        this.currentClassDoc.add(meth);
        super.visit(m, arg);
    }

    private SimpleGroovyType makeType(Type t) {
        return new SimpleGroovyType(this.withSlashes(t.asString()));
    }

    public void visit(ConstructorDeclaration c, Object arg) {
        SimpleGroovyConstructorDoc meth = new SimpleGroovyConstructorDoc(c.getNameAsString(), this.currentClassDoc);
        this.setConstructorOrMethodCommon((CallableDeclaration<? extends CallableDeclaration<?>>)c, meth);
        this.currentClassDoc.add(meth);
        super.visit(c, arg);
    }

    private void setConstructorOrMethodCommon(CallableDeclaration<? extends CallableDeclaration<?>> n, SimpleGroovyExecutableMemberDoc methOrCons) {
        n.getJavadocComment().ifPresent(javadocComment -> methOrCons.setRawCommentText(javadocComment.getContent()));
        NodeList mods = n.getModifiers();
        if (this.currentClassDoc.isInterface()) {
            mods.add((Node)Modifier.publicModifier());
        }
        this.setModifiers((NodeList<Modifier>)mods, methOrCons);
        this.processAnnotations(methOrCons, (NodeWithAnnotations<?>)n);
        for (Parameter param : n.getParameters()) {
            SimpleGroovyParameter p = new SimpleGroovyParameter(param.getNameAsString());
            this.processAnnotations(p, (NodeWithAnnotations<?>)param);
            p.setType(this.makeType(param.getType()));
            methOrCons.add(p);
        }
    }

    private void setCompactConstructor(CompactConstructorDeclaration n, SimpleGroovyExecutableMemberDoc methOrCons) {
        n.getComment().ifPresent(javadocComment -> methOrCons.setRawCommentText(javadocComment.getContent()));
        NodeList mods = n.getModifiers();
        if (this.currentClassDoc.isInterface()) {
            mods.add((Node)Modifier.publicModifier());
        }
        this.setModifiers((NodeList<Modifier>)mods, methOrCons);
        this.processAnnotations(methOrCons, (NodeWithAnnotations<?>)n);
        for (TypeParameter param : n.getTypeParameters()) {
            SimpleGroovyParameter p = new SimpleGroovyParameter(param.getNameAsString());
            this.processAnnotations(p, (NodeWithAnnotations<?>)param);
            p.setType(this.makeType((Type)param));
            methOrCons.add(p);
        }
    }

    public void visit(FieldDeclaration f, Object arg) {
        String name = f.getVariable(0).getNameAsString();
        SimpleGroovyFieldDoc field = new SimpleGroovyFieldDoc(name, this.currentClassDoc);
        field.setType(this.makeType(f.getVariable(0).getType()));
        this.setModifiers((NodeList<Modifier>)f.getModifiers(), field);
        this.processAnnotations(field, (NodeWithAnnotations<?>)f);
        f.getJavadocComment().ifPresent(javadocComment -> field.setRawCommentText(javadocComment.getContent()));
        this.currentClassDoc.add(field);
        super.visit(f, arg);
    }

    public Map<String, GroovyClassDoc> getGroovyClassDocs() {
        return this.classDocs;
    }
}

