/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection;

import grails.compiler.ast.SupportsClassNode;
import grails.compiler.traits.TraitInjector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.trait.TraitComposer;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.compiler.injection.TraitInjectionSupport;
import org.grails.core.io.support.GrailsFactoriesLoader;

public class TraitInjectionUtils {
    private static List<TraitInjector> traitInjectors;

    private TraitInjectionUtils() {
    }

    private static void extendTraits(CompilationUnit unit, SourceUnit source, ClassNode classNode) {
        if (unit.getPhase() != CompilePhase.SEMANTIC_ANALYSIS.getPhaseNumber()) {
            TraitComposer.doExtendTraits(classNode, source, unit);
        }
    }

    private static boolean addTrait(ClassNode classNode, Class trait) {
        boolean traitsAdded = false;
        boolean implementsTrait = false;
        boolean traitNotLoaded = false;
        ClassNode traitClassNode = ClassHelper.make(trait);
        try {
            implementsTrait = classNode.declaresInterface(traitClassNode);
        }
        catch (Throwable e) {
            traitNotLoaded = true;
        }
        if (!implementsTrait && !traitNotLoaded) {
            GenericsType[] genericsTypes = traitClassNode.getGenericsTypes();
            LinkedHashMap<String, ClassNode> parameterNameToParameterValue = new LinkedHashMap<String, ClassNode>();
            if (genericsTypes != null) {
                for (GenericsType gt : genericsTypes) {
                    parameterNameToParameterValue.put(gt.getName(), classNode);
                }
            }
            classNode.addInterface(GrailsASTUtils.replaceGenericsPlaceholders(traitClassNode, parameterNameToParameterValue, classNode));
            traitsAdded = true;
        }
        return traitsAdded;
    }

    public static void injectTrait(CompilationUnit unit, SourceUnit source, ClassNode classNode, Class trait) {
        boolean traitsAdded = TraitInjectionUtils.addTrait(classNode, trait);
        if (traitsAdded) {
            TraitInjectionUtils.extendTraits(unit, source, classNode);
        }
    }

    private static void doInjectionInternal(CompilationUnit unit, SourceUnit source, ClassNode classNode, List<TraitInjector> injectorsToUse) {
        boolean traitsAdded = false;
        for (TraitInjector injector : injectorsToUse) {
            Class trait = injector.getTrait();
            if (!TraitInjectionUtils.addTrait(classNode, trait)) continue;
            traitsAdded = true;
        }
        if (traitsAdded) {
            TraitInjectionUtils.extendTraits(unit, source, classNode);
        }
    }

    private static List<TraitInjector> getTraitInjectors() {
        if (traitInjectors == null) {
            traitInjectors = GrailsFactoriesLoader.loadFactories(TraitInjector.class);
            traitInjectors = TraitInjectionSupport.resolveTraitInjectors(traitInjectors);
        }
        if (traitInjectors != null) {
            return Collections.unmodifiableList(traitInjectors);
        }
        return Collections.emptyList();
    }

    public static void processTraitsForNode(SourceUnit sourceUnit, ClassNode cNode, String artefactType, CompilationUnit compilationUnit) {
        List<TraitInjector> traitInjectors = TraitInjectionUtils.getTraitInjectors();
        ArrayList<TraitInjector> injectorsToUse = new ArrayList<TraitInjector>();
        for (TraitInjector injector : traitInjectors) {
            List<String> artefactTypes = Arrays.asList(injector.getArtefactTypes());
            boolean supportsClassNode = true;
            if (injector instanceof SupportsClassNode) {
                supportsClassNode = ((SupportsClassNode)((Object)injector)).supports(cNode);
            }
            if (!artefactTypes.contains(artefactType) || !supportsClassNode) continue;
            injectorsToUse.add(injector);
        }
        try {
            if (injectorsToUse.size() > 0) {
                TraitInjectionUtils.doInjectionInternal(compilationUnit, sourceUnit, cNode, injectorsToUse);
            }
        }
        catch (RuntimeException e) {
            try {
                System.err.println("Error occurred calling Trait injector [" + TraitInjectionUtils.class.getName() + "]: " + e.getMessage());
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
    }
}

