/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.event.EventType;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractPersistenceEvent
extends ApplicationEvent {
    public static final String ONLOAD_EVENT = "onLoad";
    public static final String ONLOAD_SAVE = "onSave";
    public static final String BEFORE_LOAD_EVENT = "beforeLoad";
    public static final String BEFORE_INSERT_EVENT = "beforeInsert";
    public static final String AFTER_INSERT_EVENT = "afterInsert";
    public static final String BEFORE_UPDATE_EVENT = "beforeUpdate";
    public static final String AFTER_UPDATE_EVENT = "afterUpdate";
    public static final String BEFORE_DELETE_EVENT = "beforeDelete";
    public static final String AFTER_DELETE_EVENT = "afterDelete";
    public static final String AFTER_LOAD_EVENT = "afterLoad";
    private final PersistentEntity entity;
    private final Object entityObject;
    private final EntityAccess entityAccess;
    private boolean cancelled;
    private List<String> excludedListenerNames = new ArrayList<String>();
    private Serializable nativeEvent;

    protected AbstractPersistenceEvent(Datastore source, PersistentEntity entity, EntityAccess entityAccess) {
        this((Object)source, entity, entityAccess);
    }

    protected AbstractPersistenceEvent(Object source, PersistentEntity entity, EntityAccess entityAccess) {
        super(source);
        this.entity = entity;
        this.entityAccess = entityAccess;
        this.entityObject = entityAccess != null ? entityAccess.getEntity() : null;
    }

    protected AbstractPersistenceEvent(Object source, PersistentEntity entity) {
        this(source, entity, null);
    }

    protected AbstractPersistenceEvent(Datastore source, Object entity) {
        super(source);
        MappingContext mappingContext = source.getMappingContext();
        this.entityObject = mappingContext.getProxyHandler().unwrap(entity);
        this.entity = mappingContext.getPersistentEntity(this.entityObject.getClass().getName());
        this.entityAccess = this.entity != null ? mappingContext.createEntityAccess(this.entity, this.entityObject) : null;
    }

    public Object getEntityObject() {
        return this.entityObject;
    }

    public PersistentEntity getEntity() {
        return this.entity;
    }

    public EntityAccess getEntityAccess() {
        return this.entityAccess;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void addExcludedListenerName(String name) {
        this.excludedListenerNames.add(name);
    }

    public boolean isListenerExcluded(String name) {
        return this.excludedListenerNames.contains(name);
    }

    public void setNativeEvent(Serializable nativeEvent) {
        this.nativeEvent = nativeEvent;
    }

    public Serializable getNativeEvent() {
        return this.nativeEvent;
    }

    public abstract EventType getEventType();
}

