/*
 * Decompiled with CFR 0.152.
 */
package org.grails.spring;

import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.spring.BeanConfiguration;
import org.grails.spring.DefaultBeanConfiguration;
import org.grails.spring.GrailsApplicationContext;
import org.grails.spring.RuntimeSpringConfiguration;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;

public class DefaultRuntimeSpringConfiguration
implements RuntimeSpringConfiguration {
    private static final Log LOG = LogFactory.getLog(DefaultRuntimeSpringConfiguration.class);
    protected GenericApplicationContext context;
    private Map<String, BeanConfiguration> beanConfigs = new HashMap<String, BeanConfiguration>();
    private Map<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
    private Set<String> beanNames = new LinkedHashSet<String>();
    protected ApplicationContext parent;
    protected ClassLoader classLoader;
    protected Map<String, List<String>> aliases = new HashMap<String, List<String>>();
    protected ListableBeanFactory beanFactory;

    protected GenericApplicationContext createApplicationContext(ApplicationContext parentCtx) {
        if (parentCtx != null && this.beanFactory != null) {
            Assert.isInstanceOf(DefaultListableBeanFactory.class, (Object)this.beanFactory, "ListableBeanFactory set must be a subclass of DefaultListableBeanFactory");
            return new GrailsApplicationContext((DefaultListableBeanFactory)this.beanFactory, parentCtx);
        }
        if (this.beanFactory != null) {
            Assert.isInstanceOf(DefaultListableBeanFactory.class, (Object)this.beanFactory, "ListableBeanFactory set must be a subclass of DefaultListableBeanFactory");
            return new GrailsApplicationContext((DefaultListableBeanFactory)this.beanFactory);
        }
        if (parentCtx != null) {
            return new GrailsApplicationContext(parentCtx);
        }
        return new GrailsApplicationContext();
    }

    public DefaultRuntimeSpringConfiguration() {
    }

    public DefaultRuntimeSpringConfiguration(ApplicationContext parent) {
        this(parent, null);
    }

    public DefaultRuntimeSpringConfiguration(ApplicationContext parent, ClassLoader cl) {
        this.parent = parent;
        this.classLoader = cl;
    }

    private void trySettingClassLoaderOnContextIfFoundInParent(ApplicationContext parentCtx) {
        Object cl;
        if (parentCtx.containsBean("classLoader") && (cl = parentCtx.getBean("classLoader")) instanceof ClassLoader) {
            this.setClassLoaderOnContext((ClassLoader)cl);
        }
    }

    private void setClassLoaderOnContext(ClassLoader cl) {
        this.context.setClassLoader(cl);
        this.context.getBeanFactory().setBeanClassLoader(cl);
    }

    protected void initialiseApplicationContext() {
        if (this.context != null) {
            return;
        }
        this.context = this.createApplicationContext(this.parent);
        if (this.parent != null && this.classLoader == null) {
            this.trySettingClassLoaderOnContextIfFoundInParent(this.parent);
        } else if (this.classLoader != null) {
            this.setClassLoaderOnContext(this.classLoader);
        }
        Assert.notNull((Object)this.context, "ApplicationContext cannot be null");
    }

    @Override
    public BeanConfiguration addSingletonBean(String name, Class clazz) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, clazz);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    @Override
    public BeanConfiguration addPrototypeBean(String name, Class clazz) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, clazz, true);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        long now = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        this.initialiseApplicationContext();
        this.registerBeansWithContext(this.context);
        this.context.refresh();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created ApplicationContext in " + (System.currentTimeMillis() - now) + "ms");
        }
        return this.context;
    }

    @Override
    public ApplicationContext getUnrefreshedApplicationContext() {
        this.initialiseApplicationContext();
        return this.context;
    }

    @Override
    public BeanConfiguration addSingletonBean(String name) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    @Override
    public BeanConfiguration createSingletonBean(Class clazz) {
        return new DefaultBeanConfiguration(clazz);
    }

    @Override
    public BeanConfiguration addSingletonBean(String name, Class clazz, Collection args) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, clazz, args);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    @Override
    public BeanConfiguration addPrototypeBean(String name) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name, true);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    private void registerBeanConfiguration(String name, BeanConfiguration bc) {
        this.beanConfigs.put(name, bc);
        this.beanNames.add(name);
    }

    @Override
    public BeanConfiguration createSingletonBean(Class clazz, Collection constructorArguments) {
        return new DefaultBeanConfiguration(clazz, constructorArguments);
    }

    @Override
    public BeanConfiguration createPrototypeBean(String name) {
        return new DefaultBeanConfiguration(name, true);
    }

    @Override
    public BeanConfiguration createSingletonBean(String name) {
        return new DefaultBeanConfiguration(name);
    }

    @Override
    public void addBeanConfiguration(String beanName, BeanConfiguration beanConfiguration) {
        beanConfiguration.setName(beanName);
        this.registerBeanConfiguration(beanName, beanConfiguration);
    }

    @Override
    public void addBeanDefinition(String name, BeanDefinition bd) {
        this.beanDefinitions.put(name, bd);
        this.beanConfigs.remove(name);
        this.beanNames.add(name);
    }

    @Override
    public boolean containsBean(String name) {
        return this.beanNames.contains(name);
    }

    @Override
    public BeanConfiguration getBeanConfig(String name) {
        return this.beanConfigs.get(name);
    }

    @Override
    public AbstractBeanDefinition createBeanDefinition(String name) {
        if (this.containsBean(name)) {
            if (this.beanDefinitions.containsKey(name)) {
                return (AbstractBeanDefinition)this.beanDefinitions.get(name);
            }
            if (this.beanConfigs.containsKey(name)) {
                return this.beanConfigs.get(name).getBeanDefinition();
            }
        }
        return null;
    }

    @Override
    public void registerPostProcessor(BeanFactoryPostProcessor processor) {
        this.initialiseApplicationContext();
        this.context.addBeanFactoryPostProcessor(processor);
    }

    @Override
    public List<String> getBeanNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.beanNames));
    }

    @Override
    public void registerBeansWithContext(GenericApplicationContext applicationContext) {
        this.registerBeansWithRegistry(applicationContext);
    }

    @Override
    public void registerBeansWithRegistry(BeanDefinitionRegistry registry) {
        this.registerUnrefreshedBeansWithRegistry(registry);
        this.registerBeanConfigsWithRegistry(registry);
        this.registerBeanDefinitionsWithRegistry(registry);
        this.registerBeanAliasesWithRegistry(registry);
    }

    private void registerUnrefreshedBeansWithRegistry(BeanDefinitionRegistry registry) {
        if (this.context != null) {
            for (String beanName : this.context.getBeanDefinitionNames()) {
                registry.registerBeanDefinition(beanName, this.context.getBeanDefinition(beanName));
            }
        }
    }

    private void registerBeanConfigsWithRegistry(BeanDefinitionRegistry registry) {
        for (BeanConfiguration bc : this.beanConfigs.values()) {
            String beanName = bc.getName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("[RuntimeConfiguration] Registering bean [" + beanName + "]");
                if (LOG.isTraceEnabled()) {
                    PropertyValue[] pvs;
                    for (PropertyValue pv : pvs = bc.getBeanDefinition().getPropertyValues().getPropertyValues()) {
                        LOG.trace("[RuntimeConfiguration] With property [" + pv.getName() + "] set to [" + String.valueOf(pv.getValue()) + "]");
                    }
                }
            }
            registry.registerBeanDefinition(beanName, bc.getBeanDefinition());
        }
    }

    private void registerBeanDefinitionsWithRegistry(BeanDefinitionRegistry registry) {
        for (String key : this.beanDefinitions.keySet()) {
            BeanDefinition bd = this.beanDefinitions.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[RuntimeConfiguration] Registering bean [" + String.valueOf(key) + "]");
                if (LOG.isTraceEnabled()) {
                    PropertyValue[] pvs;
                    for (PropertyValue pv : pvs = bd.getPropertyValues().getPropertyValues()) {
                        LOG.trace("[RuntimeConfiguration] With property [" + pv.getName() + "] set to [" + String.valueOf(pv.getValue()) + "]");
                    }
                }
            }
            String beanName = key.toString();
            registry.registerBeanDefinition(beanName, bd);
        }
    }

    @Override
    public void registerBeansWithConfig(RuntimeSpringConfiguration targetSpringConfig) {
        if (targetSpringConfig == null) {
            return;
        }
        ApplicationContext ctx = targetSpringConfig.getUnrefreshedApplicationContext();
        if (ctx instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)((Object)ctx);
            this.registerUnrefreshedBeansWithRegistry(registry);
            this.registerBeansWithRegistry(registry);
        }
        for (Map.Entry<String, BeanConfiguration> beanEntry : this.beanConfigs.entrySet()) {
            targetSpringConfig.addBeanConfiguration(beanEntry.getKey(), beanEntry.getValue());
        }
    }

    private void registerBeanAliasesWithRegistry(BeanDefinitionRegistry beanDefinitionRegistry) {
        for (Map.Entry<String, List<String>> entry : this.aliases.entrySet()) {
            String beanName = entry.getKey();
            List<String> beanAliases = entry.getValue();
            if (beanAliases == null || beanAliases.isEmpty()) continue;
            for (String alias : beanAliases) {
                beanDefinitionRegistry.registerAlias(beanName, alias);
            }
        }
    }

    private void removeBeanDefinition(BeanDefinitionRegistry registry, String beanName) {
        MetaClass mc = GroovySystem.getMetaClassRegistry().getMetaClass(registry.getClass());
        if (!mc.respondsTo(registry, "removeBeanDefinition").isEmpty()) {
            mc.invokeMethod((Object)registry, "removeBeanDefinition", new Object[]{beanName});
        }
    }

    @Override
    public BeanConfiguration addAbstractBean(String name) {
        DefaultBeanConfiguration bc = new DefaultBeanConfiguration(name);
        bc.setAbstract(true);
        this.registerBeanConfiguration(name, bc);
        return bc;
    }

    @Override
    public void addAlias(String alias, String beanName) {
        List<String> beanAliases = this.aliases.get(beanName);
        if (beanAliases == null) {
            beanAliases = new ArrayList<String>();
            this.aliases.put(beanName, beanAliases);
        }
        beanAliases.add(alias);
    }

    @Override
    public BeanDefinition getBeanDefinition(String beanName) {
        return this.beanDefinitions.get(beanName);
    }

    @Override
    public void setBeanFactory(ListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

