/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.properties.bind.BindableRuntimeHintsRegistrar;
import org.springframework.boot.logging.LoggingSystemProperty;
import org.springframework.core.env.Environment;

class ApplicationProperties {
    private boolean allowBeanDefinitionOverriding;
    private boolean allowCircularReferences;
    private Banner.Mode bannerMode;
    private boolean keepAlive;
    private boolean lazyInitialization;
    private boolean logStartupInfo = true;
    private boolean registerShutdownHook = true;
    private Set<String> sources = new LinkedHashSet<String>();
    private WebApplicationType webApplicationType;

    ApplicationProperties() {
    }

    boolean isAllowBeanDefinitionOverriding() {
        return this.allowBeanDefinitionOverriding;
    }

    void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    boolean isAllowCircularReferences() {
        return this.allowCircularReferences;
    }

    void setAllowCircularReferences(boolean allowCircularReferences) {
        this.allowCircularReferences = allowCircularReferences;
    }

    Banner.Mode getBannerMode(Environment environment2) {
        if (this.bannerMode != null) {
            return this.bannerMode;
        }
        boolean structuredLoggingEnabled = environment2.containsProperty(LoggingSystemProperty.CONSOLE_STRUCTURED_FORMAT.getApplicationPropertyName());
        return structuredLoggingEnabled ? Banner.Mode.OFF : Banner.Mode.CONSOLE;
    }

    void setBannerMode(Banner.Mode bannerMode) {
        this.bannerMode = bannerMode;
    }

    boolean isKeepAlive() {
        return this.keepAlive;
    }

    void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    boolean isLazyInitialization() {
        return this.lazyInitialization;
    }

    void setLazyInitialization(boolean lazyInitialization) {
        this.lazyInitialization = lazyInitialization;
    }

    boolean isLogStartupInfo() {
        return this.logStartupInfo;
    }

    void setLogStartupInfo(boolean logStartupInfo) {
        this.logStartupInfo = logStartupInfo;
    }

    boolean isRegisterShutdownHook() {
        return this.registerShutdownHook;
    }

    void setRegisterShutdownHook(boolean registerShutdownHook) {
        this.registerShutdownHook = registerShutdownHook;
    }

    Set<String> getSources() {
        return this.sources;
    }

    void setSources(Set<String> sources) {
        this.sources = new LinkedHashSet<String>(sources);
    }

    WebApplicationType getWebApplicationType() {
        return this.webApplicationType;
    }

    void setWebApplicationType(WebApplicationType webApplicationType) {
        this.webApplicationType = webApplicationType;
    }

    static class ApplicationPropertiesRuntimeHints
    implements RuntimeHintsRegistrar {
        ApplicationPropertiesRuntimeHints() {
        }

        @Override
        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            BindableRuntimeHintsRegistrar.forTypes(ApplicationProperties.class).registerHints(hints, classLoader);
        }
    }
}

