/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.ansi.AnsiPropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class ResourceBanner
implements Banner {
    private static final Log logger = LogFactory.getLog(ResourceBanner.class);
    private final Resource resource;

    public ResourceBanner(Resource resource) {
        Assert.notNull((Object)resource, "'resource' must not be null");
        Assert.isTrue(resource.exists(), "'resource' must exist");
        this.resource = resource;
    }

    @Override
    public void printBanner(Environment environment2, Class<?> sourceClass, PrintStream out) {
        try (InputStream input = this.resource.getInputStream();){
            String banner = StreamUtils.copyToString(input, environment2.getProperty("spring.banner.charset", Charset.class, StandardCharsets.UTF_8));
            for (PropertyResolver resolver : this.getPropertyResolvers(environment2, sourceClass)) {
                banner = resolver.resolvePlaceholders(banner);
            }
            out.println(banner);
        }
        catch (Exception ex) {
            logger.warn(LogMessage.format("Banner not printable: %s (%s: '%s')", (Object)this.resource, ex.getClass(), (Object)ex.getMessage()), ex);
        }
    }

    protected List<PropertyResolver> getPropertyResolvers(Environment environment2, Class<?> sourceClass) {
        ArrayList<PropertyResolver> resolvers = new ArrayList<PropertyResolver>();
        resolvers.add(new PropertySourcesPropertyResolver(this.createNullDefaultSources(environment2, sourceClass)));
        resolvers.add(new PropertySourcesPropertyResolver(this.createEmptyDefaultSources(environment2, sourceClass)));
        return resolvers;
    }

    private MutablePropertySources createNullDefaultSources(Environment environment2, Class<?> sourceClass) {
        MutablePropertySources nullDefaultSources = new MutablePropertySources();
        if (environment2 instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment2;
            configurableEnvironment.getPropertySources().forEach(nullDefaultSources::addLast);
        }
        nullDefaultSources.addLast(this.getTitleSource(sourceClass, null));
        nullDefaultSources.addLast(this.getAnsiSource());
        nullDefaultSources.addLast(this.getVersionSource(sourceClass, environment2, null));
        return nullDefaultSources;
    }

    private MutablePropertySources createEmptyDefaultSources(Environment environment2, Class<?> sourceClass) {
        MutablePropertySources emptyDefaultSources = new MutablePropertySources();
        emptyDefaultSources.addLast(this.getTitleSource(sourceClass, ""));
        emptyDefaultSources.addLast(this.getVersionSource(sourceClass, environment2, ""));
        return emptyDefaultSources;
    }

    private MapPropertySource getTitleSource(Class<?> sourceClass, String defaultValue) {
        String applicationTitle = this.getApplicationTitle(sourceClass);
        Map<String, Object> titleMap = Collections.singletonMap("application.title", applicationTitle != null ? applicationTitle : defaultValue);
        return new MapPropertySource("title", titleMap);
    }

    protected String getApplicationTitle(Class<?> sourceClass) {
        Package sourcePackage = sourceClass != null ? sourceClass.getPackage() : null;
        return sourcePackage != null ? sourcePackage.getImplementationTitle() : null;
    }

    private AnsiPropertySource getAnsiSource() {
        return new AnsiPropertySource("ansi", true);
    }

    private MapPropertySource getVersionSource(Class<?> sourceClass, Environment environment2, String defaultValue) {
        return new MapPropertySource("version", this.getVersionsMap(sourceClass, environment2, defaultValue));
    }

    private Map<String, Object> getVersionsMap(Class<?> sourceClass, Environment environment2, String defaultValue) {
        String appVersion = this.getApplicationVersion(sourceClass);
        if (appVersion == null) {
            appVersion = this.getApplicationVersion(environment2);
        }
        String bootVersion = this.getBootVersion();
        HashMap<String, Object> versions = new HashMap<String, Object>();
        versions.put("application.version", this.getVersionString(appVersion, false, defaultValue));
        versions.put("spring-boot.version", this.getVersionString(bootVersion, false, defaultValue));
        versions.put("application.formatted-version", this.getVersionString(appVersion, true, defaultValue));
        versions.put("spring-boot.formatted-version", this.getVersionString(bootVersion, true, defaultValue));
        return versions;
    }

    @Deprecated(since="3.4.0", forRemoval=true)
    protected String getApplicationVersion(Class<?> sourceClass) {
        return null;
    }

    private String getApplicationVersion(Environment environment2) {
        return environment2.getProperty("spring.application.version");
    }

    protected String getBootVersion() {
        return SpringBootVersion.getVersion();
    }

    private String getVersionString(String version, boolean format, String fallback) {
        if (version == null) {
            return fallback;
        }
        return format ? " (v" + version + ")" : version;
    }
}

