/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.communication;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.internal.managers.communication.TransmissionPolicy;
import org.apache.ignite.internal.util.typedef.internal.S;

public class TransmissionMeta
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private String name;
    private long offset;
    private long cnt;
    private Map<String, Serializable> params;
    private TransmissionPolicy plc;
    private Exception err;

    public TransmissionMeta() {
        this(null);
    }

    public TransmissionMeta(Exception err) {
        this("", -1L, -1L, null, null, err);
    }

    public TransmissionMeta(String name, long offset, long cnt, Map<String, Serializable> params, TransmissionPolicy plc, Exception err) {
        assert (params instanceof Serializable || params == null) : params.getClass();
        this.name = name;
        this.offset = offset;
        this.cnt = cnt;
        this.params = params;
        this.plc = plc;
        this.err = err;
    }

    public String name() {
        assert (this.name != null);
        return this.name;
    }

    public long offset() {
        return this.offset;
    }

    public long count() {
        return this.cnt;
    }

    public Map<String, Serializable> params() {
        return this.params;
    }

    public TransmissionPolicy policy() {
        return this.plc;
    }

    public TransmissionMeta error(Exception err) {
        this.err = err;
        return this;
    }

    public Exception error() {
        return this.err;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.offset);
        out.writeLong(this.cnt);
        out.writeObject(this.params);
        out.writeObject((Object)this.plc);
        out.writeObject(this.err);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.offset = in.readLong();
        this.cnt = in.readLong();
        this.params = (Map)in.readObject();
        this.plc = (TransmissionPolicy)((Object)in.readObject());
        this.err = (Exception)in.readObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransmissionMeta meta = (TransmissionMeta)o;
        return this.offset == meta.offset && this.cnt == meta.cnt && this.name.equals(meta.name) && Objects.equals(this.params, meta.params) && this.plc == meta.plc && Objects.equals(this.err, meta.err);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.offset, this.cnt, this.params, this.plc, this.err});
    }

    public String toString() {
        return S.toString(TransmissionMeta.class, this);
    }
}

