/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.record.datapoint;

import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.write.chunk.ChunkWriterImpl;
import org.apache.tsfile.write.record.datapoint.DataPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntDataPoint
extends DataPoint {
    private static final Logger LOG = LoggerFactory.getLogger(IntDataPoint.class);
    private int value;

    public IntDataPoint(String measurementId, int v) {
        super(TSDataType.INT32, measurementId);
        this.value = v;
    }

    @Override
    public void writeTo(long time, ChunkWriterImpl writer) {
        if (writer == null) {
            LOG.warn("given IChunkWriter is null, do nothing and return");
            return;
        }
        writer.write(time, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setInteger(int value) {
        this.value = value;
    }
}

