/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnSchema;
import org.apache.iotdb.db.queryengine.execution.operator.process.FilterAndProjectOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.DeviceUpdater;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.leaf.LeafColumnTransformer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.info.TableDeviceInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.ratis.util.function.TriConsumer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.utils.Binary;

public class DeviceAttributeUpdater
extends DeviceUpdater {
    private final List<ColumnTransformer> commonTransformerList;
    private final List<LeafColumnTransformer> projectLeafColumnTransformerList;
    private final List<ColumnTransformer> projectOutputTransformerList;
    private final TriConsumer<String[], Integer, Object[]> attributeUpdater;
    private final TsBlockBuilder filterTsBlockBuilder;
    private final List<Integer> attributePointers = new ArrayList<Integer>();
    private final List<String> attributeNames;

    public DeviceAttributeUpdater(List<TSDataType> filterOutputDataTypes, List<LeafColumnTransformer> filterLeafColumnTransformerList, ColumnTransformer filterOutputTransformer, List<ColumnTransformer> commonTransformerList, List<TsTableColumnSchema> columnSchemaList, List<LeafColumnTransformer> projectLeafColumnTransformerList, List<ColumnTransformer> projectOutputTransformerList, BiFunction<Integer, String, Binary> attributeProvider, TriConsumer<String[], Integer, Object[]> attributeUpdater, List<String> attributeNames, String database, TsTable table) {
        super(filterLeafColumnTransformerList, filterOutputTransformer, columnSchemaList, attributeProvider, database, table);
        this.commonTransformerList = commonTransformerList;
        this.projectLeafColumnTransformerList = projectLeafColumnTransformerList;
        this.projectOutputTransformerList = projectOutputTransformerList;
        this.attributeUpdater = attributeUpdater;
        this.filterTsBlockBuilder = new TsBlockBuilder(filterOutputDataTypes);
        this.attributeNames = attributeNames;
    }

    @Override
    public void handleDeviceNode(IDeviceMNode<IMemMNode> node) throws MetadataException {
        this.attributePointers.add(((TableDeviceInfo)node.getDeviceInfo()).getAttributePointer());
        super.handleDeviceNode(node);
    }

    @Override
    protected void update() throws MetadataException {
        TsBlock block = this.getFilterTsBlock();
        this.projectLeafColumnTransformerList.forEach(leafColumnTransformer -> leafColumnTransformer.initFromTsBlock(block));
        List resultColumns = this.projectOutputTransformerList.stream().map(columnTransformer -> {
            columnTransformer.tryEvaluate();
            return columnTransformer.getColumn();
        }).collect(Collectors.toList());
        for (int i = 0; i < (this.withoutFilter() ? this.attributePointers.size() : this.indexes.size()); ++i) {
            String[] nodes = ((IDeviceSchemaInfo)this.deviceSchemaBatch.get(this.withoutFilter() ? i : (Integer)this.indexes.get(i))).getRawNodes();
            Object[] results = new Object[resultColumns.size()];
            for (int j = 0; j < resultColumns.size(); ++j) {
                Object o;
                Object object = o = ((Column)resultColumns.get(j)).isNull(i) ? null : ((Column)resultColumns.get(j)).getObject(i);
                if (Objects.nonNull(o) && !(o instanceof Binary)) {
                    throw new MetadataException("Result type mismatch for attribute '" + this.attributeNames.get(j) + "', expected " + Binary.class + ", actual " + o.getClass());
                }
                results[j] = o;
            }
            this.attributeUpdater.accept((Object)Arrays.copyOfRange(nodes, 3, nodes.length), (Object)this.attributePointers.get(this.withoutFilter() ? i : (Integer)this.indexes.get(i)), (Object)results);
        }
        this.attributePointers.clear();
        super.clear();
    }

    private TsBlock getFilterTsBlock() {
        if (this.withoutFilter()) {
            return this.curBlock;
        }
        this.filterTsBlockBuilder.reset();
        ArrayList<Column> filterResultColumns = new ArrayList<Column>(Arrays.asList(this.curBlock.getValueColumns()));
        this.commonTransformerList.forEach(columnTransformer -> filterResultColumns.add(columnTransformer.getColumn()));
        ColumnBuilder[] columnBuilders = this.filterTsBlockBuilder.getValueColumnBuilders();
        int rowCount = FilterAndProjectOperator.constructFilteredTsBlock(filterResultColumns, this.curFilterColumn, columnBuilders, this.deviceSchemaBatch.size());
        this.filterTsBlockBuilder.declarePositions(rowCount);
        return this.filterTsBlockBuilder.build((Column)new TimeColumn(rowCount, new long[rowCount]));
    }

    @Override
    public void close() throws MetadataException {
        super.close();
        this.projectOutputTransformerList.forEach(ColumnTransformer::close);
    }
}

