/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class DecimalLiteral
extends Literal {
    private final String value;

    public DecimalLiteral(String value) {
        super(null);
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public DecimalLiteral(NodeLocation location, String value) {
        super(Objects.requireNonNull(location, "location is null"));
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDecimalLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalLiteral that = (DecimalLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!DecimalLiteral.sameClass(this, other)) {
            return false;
        }
        DecimalLiteral otherLiteral = (DecimalLiteral)other;
        return this.value.equals(otherLiteral.value);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.DECIMAL_LITERAL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.value, (OutputStream)stream);
    }

    public DecimalLiteral(ByteBuffer byteBuffer) {
        super(null);
        this.value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    @Override
    public Object getTsValue() {
        return new Binary(this.value.getBytes(StandardCharsets.UTF_8));
    }
}

