/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.stream.Stream;
import org.apache.jena.atlas.lib.Copyable;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.mem.store.TripleStore;
import org.apache.jena.util.iterator.ExtendedIterator;

public class GraphMem
extends GraphBase
implements GraphWithPerform,
Copyable<GraphMem> {
    final TripleStore tripleStore;

    protected GraphMem(TripleStore tripleStore) {
        this.tripleStore = tripleStore;
    }

    @Override
    public void clear() {
        super.clear();
        this.tripleStore.clear();
    }

    @Override
    public void performAdd(Triple t) {
        this.tripleStore.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.tripleStore.remove(t);
    }

    @Override
    public Stream<Triple> stream() {
        return this.tripleStore.stream();
    }

    @Override
    public Stream<Triple> stream(Node sm, Node pm, Node om) {
        return this.tripleStore.stream(Triple.createMatch(sm, pm, om));
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Triple tripleMatch) {
        return this.tripleStore.find(tripleMatch);
    }

    @Override
    public boolean graphBaseContains(Triple tripleMatch) {
        return this.tripleStore.contains(tripleMatch);
    }

    @Override
    public int graphBaseSize() {
        return this.tripleStore.countTriples();
    }

    public GraphMem copy() {
        return new GraphMem(this.tripleStore.copy());
    }
}

