/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.traces;

import io.opentelemetry.exporter.logging.otlp.internal.traces.OtlpStdoutSpanExporter;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.exporter.logging.otlp.internal.writer.LoggerJsonWriter;
import io.opentelemetry.exporter.logging.otlp.internal.writer.StreamJsonWriter;
import io.opentelemetry.sdk.common.export.MemoryMode;
import java.io.OutputStream;
import java.util.Objects;
import java.util.logging.Logger;

public final class OtlpStdoutSpanExporterBuilder {
    private static final String TYPE = "spans";
    private final Logger logger;
    private JsonWriter jsonWriter;
    private boolean wrapperJsonObject = true;
    private MemoryMode memoryMode = MemoryMode.IMMUTABLE_DATA;

    public OtlpStdoutSpanExporterBuilder(Logger logger) {
        this.logger = logger;
        this.jsonWriter = new LoggerJsonWriter(logger, TYPE);
    }

    public OtlpStdoutSpanExporterBuilder setWrapperJsonObject(boolean wrapperJsonObject) {
        this.wrapperJsonObject = wrapperJsonObject;
        return this;
    }

    public OtlpStdoutSpanExporterBuilder setMemoryMode(MemoryMode memoryMode) {
        this.memoryMode = memoryMode;
        return this;
    }

    public OtlpStdoutSpanExporterBuilder setOutput(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        this.jsonWriter = new StreamJsonWriter(outputStream, TYPE);
        return this;
    }

    public OtlpStdoutSpanExporterBuilder setOutput(Logger logger) {
        Objects.requireNonNull(logger, "logger");
        this.jsonWriter = new LoggerJsonWriter(logger, TYPE);
        return this;
    }

    public OtlpStdoutSpanExporter build() {
        if (this.memoryMode == MemoryMode.REUSABLE_DATA && !this.wrapperJsonObject) {
            throw new IllegalArgumentException("Reusable data mode is not supported without wrapperJsonObject");
        }
        return new OtlpStdoutSpanExporter(this.logger, this.jsonWriter, this.wrapperJsonObject, this.memoryMode);
    }
}

