/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.metrics;

import com.google.common.collect.Lists;
import io.netty.util.concurrent.Future;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.ViewBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.rocketmq.common.Pair;
import org.apache.rocketmq.common.metrics.NopLongHistogram;

public class RemotingMetricsManager {
    private LongHistogram rpcLatency = new NopLongHistogram();
    private Supplier<AttributesBuilder> attributesBuilderSupplier;

    public AttributesBuilder newAttributesBuilder() {
        if (this.attributesBuilderSupplier == null) {
            return Attributes.builder();
        }
        return this.attributesBuilderSupplier.get().put("protocol_type", "remoting");
    }

    public void initMetrics(Meter meter, Supplier<AttributesBuilder> attributesBuilderSupplier) {
        this.attributesBuilderSupplier = attributesBuilderSupplier;
        this.rpcLatency = meter.histogramBuilder("rocketmq_rpc_latency").setDescription("Rpc latency").setUnit("milliseconds").ofLongs().build();
    }

    public List<Pair<InstrumentSelector, ViewBuilder>> getMetricsView() {
        List<Double> rpcCostTimeBuckets = Arrays.asList(Duration.ofMillis(1L).toMillis(), Duration.ofMillis(3L).toMillis(), Duration.ofMillis(5L).toMillis(), Duration.ofMillis(7L).toMillis(), Duration.ofMillis(10L).toMillis(), Duration.ofMillis(100L).toMillis(), Duration.ofSeconds(1L).toMillis(), Duration.ofSeconds(2L).toMillis(), Duration.ofSeconds(3L).toMillis());
        InstrumentSelector selector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setName("rocketmq_rpc_latency").build();
        ViewBuilder viewBuilder = View.builder().setAggregation(Aggregation.explicitBucketHistogram(rpcCostTimeBuckets));
        return Lists.newArrayList((Object[])new Pair[]{new Pair((Object)selector, (Object)viewBuilder)});
    }

    public String getWriteAndFlushResult(Future<?> future) {
        String result = "success";
        if (future.isCancelled()) {
            result = "cancelled";
        } else if (!future.isSuccess()) {
            result = "write_channel_failed";
        }
        return result;
    }

    public LongHistogram getRpcLatency() {
        return this.rpcLatency;
    }

    public Supplier<AttributesBuilder> getAttributesBuilderSupplier() {
        return this.attributesBuilderSupplier;
    }

    public void setAttributesBuilderSupplier(Supplier<AttributesBuilder> attributesBuilderSupplier) {
        this.attributesBuilderSupplier = attributesBuilderSupplier;
    }
}

