/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExtBrokerInner;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.exception.ConsumeQueueException;

public class LmqDispatch {
    private static final short VALUE_OF_EACH_INCREMENT = 1;

    public static void wrapLmqDispatch(MessageStore messageStore, MessageExtBrokerInner msg) throws ConsumeQueueException {
        String lmqNames = msg.getProperty("INNER_MULTI_DISPATCH");
        String[] queueNames = lmqNames.split(",");
        Object[] queueOffsets = new Long[queueNames.length];
        if (messageStore.getMessageStoreConfig().isEnableLmq()) {
            for (int i = 0; i < queueNames.length; ++i) {
                if (!MixAll.isLmq((String)queueNames[i])) continue;
                queueOffsets[i] = messageStore.getQueueStore().getLmqQueueOffset(queueNames[i], 0);
            }
        }
        MessageAccessor.putProperty((Message)msg, (String)"INNER_MULTI_QUEUE_OFFSET", (String)StringUtils.join((Object[])queueOffsets, (String)","));
        msg.removeWaitStorePropertyString();
    }

    public static void updateLmqOffsets(MessageStore messageStore, MessageExtBrokerInner msgInner) throws ConsumeQueueException {
        String[] queueNames;
        String lmqNames = msgInner.getProperty("INNER_MULTI_DISPATCH");
        for (String queueName : queueNames = lmqNames.split(",")) {
            if (!messageStore.getMessageStoreConfig().isEnableLmq() || !MixAll.isLmq((String)queueName)) continue;
            messageStore.getQueueStore().increaseLmqOffset(queueName, 0, (short)1);
        }
    }
}

