/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import com.google.common.base.Preconditions;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.FileQueueSnapshot;
import org.apache.rocketmq.store.MappedFileQueue;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.logfile.MappedFile;

public class StoreUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    public static final long TOTAL_PHYSICAL_MEMORY_SIZE = StoreUtil.getTotalPhysicalMemorySize();

    public static long getTotalPhysicalMemorySize() {
        long physicalTotal = 0x600000000L;
        java.lang.management.OperatingSystemMXBean osmxb = ManagementFactory.getOperatingSystemMXBean();
        if (osmxb instanceof OperatingSystemMXBean) {
            physicalTotal = ((OperatingSystemMXBean)osmxb).getTotalPhysicalMemorySize();
        }
        return physicalTotal;
    }

    public static void fileAppend(MappedFile file, ByteBuffer data) {
        boolean success = file.appendMessage(data);
        if (!success) {
            throw new RuntimeException(String.format("fileAppend failed for file: %s and data remaining: %d", file, data.remaining()));
        }
    }

    public static FileQueueSnapshot getFileQueueSnapshot(MappedFileQueue mappedFileQueue) {
        return StoreUtil.getFileQueueSnapshot(mappedFileQueue, mappedFileQueue.getLastMappedFile().getFileFromOffset());
    }

    public static FileQueueSnapshot getFileQueueSnapshot(MappedFileQueue mappedFileQueue, long currentFile) {
        try {
            Preconditions.checkNotNull((Object)mappedFileQueue, (Object)"file queue shouldn't be null");
            MappedFile firstFile = mappedFileQueue.getFirstMappedFile();
            MappedFile lastFile = mappedFileQueue.getLastMappedFile();
            int mappedFileSize = mappedFileQueue.getMappedFileSize();
            if (firstFile == null || lastFile == null) {
                return new FileQueueSnapshot(firstFile, -1L, lastFile, -1L, currentFile, -1L, 0L, false);
            }
            long firstFileIndex = 0L;
            long lastFileIndex = (lastFile.getFileFromOffset() - firstFile.getFileFromOffset()) / (long)mappedFileSize;
            long currentFileIndex = (currentFile - firstFile.getFileFromOffset()) / (long)mappedFileSize;
            long behind = (lastFile.getFileFromOffset() - currentFile) / (long)mappedFileSize;
            boolean exist = firstFile.getFileFromOffset() <= currentFile && currentFile <= lastFile.getFileFromOffset();
            return new FileQueueSnapshot(firstFile, firstFileIndex, lastFile, lastFileIndex, currentFile, currentFileIndex, behind, exist);
        }
        catch (Exception e) {
            log.error("[BUG] get file queue snapshot failed. fileQueue: {}, currentFile: {}", new Object[]{mappedFileQueue, currentFile, e});
            return new FileQueueSnapshot();
        }
    }

    public static MessageExt getMessage(long offsetPy, int sizePy, MessageStore messageStore, ByteBuffer byteBuffer) {
        try {
            if (offsetPy < 0L || sizePy <= 0 || null == messageStore || null == byteBuffer) {
                return null;
            }
            byteBuffer.position(0);
            byteBuffer.limit(sizePy);
            if (!messageStore.getData(offsetPy, sizePy, byteBuffer)) {
                return null;
            }
            byteBuffer.flip();
            return MessageDecoder.decode((ByteBuffer)byteBuffer, (boolean)true, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            log.error("getMessage error, offsetPy: {}, sizePy: {}, error: {}", new Object[]{offsetPy, sizePy, e.getMessage()});
            return null;
        }
    }
}

