/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.transaction;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class TransRocksDBRecord {
    private static final Logger logError = LoggerFactory.getLogger((String)"RocketmqStoreError");
    public static final int VALUE_LENGTH = 8;
    private static final String KEY_SPLIT = "@";
    protected long offsetPy;
    private String topic;
    private String uniqKey;
    private int checkTimes = 0;
    private int sizePy;
    private boolean isOp;
    private boolean delete;
    private MessageExt messageExt;

    public TransRocksDBRecord(long offsetPy, String topic, String uniqKey, int sizePy, int checkTimes) {
        this.offsetPy = offsetPy;
        this.topic = topic;
        this.uniqKey = uniqKey;
        this.sizePy = sizePy;
        this.checkTimes = checkTimes;
    }

    public TransRocksDBRecord(long offsetPy, String topic, String uniqKey, boolean isOp) {
        this.offsetPy = offsetPy;
        this.topic = topic;
        this.uniqKey = uniqKey;
        this.isOp = isOp;
    }

    public TransRocksDBRecord() {
    }

    public byte[] getKeyBytes() {
        if (this.offsetPy < 0L || StringUtils.isEmpty((CharSequence)this.topic) || StringUtils.isEmpty((CharSequence)this.uniqKey)) {
            return null;
        }
        byte[] keySuffixBytes = (KEY_SPLIT + this.topic + KEY_SPLIT + this.uniqKey).getBytes(StandardCharsets.UTF_8);
        int keyLength = 8 + keySuffixBytes.length;
        return ByteBuffer.allocate(keyLength).putLong(this.offsetPy).put(keySuffixBytes).array();
    }

    public byte[] getValueBytes() {
        if (this.checkTimes < 0 || this.sizePy <= 0) {
            logError.error("TransRocksDBRecord getValueBytes error, checkTimes: {}, sizePy: {}", (Object)this.checkTimes, (Object)this.sizePy);
            return null;
        }
        return ByteBuffer.allocate(8).putInt(this.checkTimes).putInt(this.sizePy).array();
    }

    public static TransRocksDBRecord decode(byte[] key, byte[] value) {
        if (null == key || key.length <= 8 || null == value || value.length != 8) {
            logError.error("TransRocksDBRecord decode param error, key: {}, value: {}", (Object)key, (Object)value);
            return null;
        }
        TransRocksDBRecord transRocksDBRecord = null;
        try {
            transRocksDBRecord = new TransRocksDBRecord();
            ByteBuffer keyByteBuffer = ByteBuffer.wrap(key);
            transRocksDBRecord.setOffsetPy(keyByteBuffer.getLong());
            byte[] keySuffix = new byte[key.length - 8];
            keyByteBuffer.get(keySuffix);
            String[] keySuffixSplit = new String(keySuffix, StandardCharsets.UTF_8).split(KEY_SPLIT);
            if (keySuffixSplit.length != 3) {
                logError.error("TransRocksDBRecord decode keySuffixSplit parse error");
                return null;
            }
            transRocksDBRecord.setTopic(keySuffixSplit[1]);
            transRocksDBRecord.setUniqKey(keySuffixSplit[2]);
            ByteBuffer valueByteBuffer = ByteBuffer.wrap(value);
            transRocksDBRecord.setCheckTimes(valueByteBuffer.getInt());
            transRocksDBRecord.setSizePy(valueByteBuffer.getInt());
        }
        catch (Exception e) {
            logError.error("TransRocksDBRecord decode error, valueLength: {}, error: {}", (Object)value.length, (Object)e.getMessage());
            return null;
        }
        return transRocksDBRecord;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getUniqKey() {
        return this.uniqKey;
    }

    public void setUniqKey(String uniqKey) {
        this.uniqKey = uniqKey;
    }

    public int getCheckTimes() {
        return this.checkTimes;
    }

    public void setCheckTimes(int checkTimes) {
        this.checkTimes = checkTimes;
    }

    public int getSizePy() {
        return this.sizePy;
    }

    public void setSizePy(int sizePy) {
        this.sizePy = sizePy;
    }

    public long getOffsetPy() {
        return this.offsetPy;
    }

    public void setOffsetPy(long offsetPy) {
        this.offsetPy = offsetPy;
    }

    public MessageExt getMessageExt() {
        return this.messageExt;
    }

    public void setMessageExt(MessageExt messageExt) {
        this.messageExt = messageExt;
    }

    public boolean isOp() {
        return this.isOp;
    }

    public void setOp(boolean op) {
        this.isOp = op;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }
}

