/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.metrics.meter;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.metrics.meter.LatencyScopeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyDistributionConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(LatencyDistributionConfig.class);
    private final List<LatencyScopeConfig> scopeConfigs = new ArrayList<LatencyScopeConfig>();

    public LatencyDistributionConfig(String config) {
        if (StringUtils.isEmpty((CharSequence)config)) {
            return;
        }
        config = config.trim() + "," + Long.MAX_VALUE;
        String[] array = config.split("\\s*,+\\s*");
        try {
            for (int idx = 0; idx < array.length - 1; ++idx) {
                long msMax;
                long msMin = Long.parseLong(array[idx]);
                if (msMin >= (msMax = Long.parseLong(array[idx + 1]))) {
                    String msg = String.format("invalid latency scope, min=%s, max=%s.", array[idx], array[idx + 1]);
                    throw new IllegalStateException(msg);
                }
                LatencyScopeConfig latencyScopeConfig = new LatencyScopeConfig(msMin, msMax);
                this.scopeConfigs.add(latencyScopeConfig);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to parse latencyDistributionConfig, value={}", (Object)config, (Object)e);
            throw e;
        }
    }

    public List<LatencyScopeConfig> getScopeConfigs() {
        return this.scopeConfigs;
    }
}

