/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.event;

import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutionException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.event.StoreEvent;
import org.apache.sis.storage.event.StoreListener;
import org.apache.sis.storage.event.StoreListeners;

public abstract class CascadedStoreEvent<E extends CascadedStoreEvent<E>>
extends StoreEvent {
    private static final long serialVersionUID = -1319167650150261418L;

    protected CascadedStoreEvent(Resource source) {
        super(source);
    }

    protected abstract E forSource(Resource var1);

    static final class ParentListener<E extends CascadedStoreEvent<E>>
    implements StoreListener<E> {
        private final Class<E> eventType;
        private final StoreListeners parent;
        private final WeakReference<StoreListeners> listeners;

        ParentListener(Class<E> eventType, StoreListeners parent, StoreListeners listeners) {
            this.eventType = eventType;
            this.parent = parent;
            this.listeners = new WeakReference<StoreListeners>(listeners);
        }

        @Override
        public void eventOccured(E event) {
            StoreListeners r = (StoreListeners)this.listeners.get();
            if (r == null) {
                this.parent.removeListener(this.eventType, this);
            } else {
                try {
                    Object cascade = ((CascadedStoreEvent)event).forSource(r.getSource());
                    ((StoreEvent)cascade).consume(true);
                    StoreListeners.fire(r, this.eventType, cascade);
                }
                catch (ExecutionException e) {
                    StoreListeners.canNotNotify("fire (cascade)", e);
                }
            }
        }
    }
}

