/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.IntFunction;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.coverage.grid.TranslatedTransform;
import org.apache.sis.coverage.grid.ValuesAtPointIterator;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.geometry.CoordinateFormat;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.internal.shared.DirectPositionView;
import org.apache.sis.referencing.internal.shared.WraparoundAxesFinder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.TransformSeparator;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

abstract class DefaultEvaluator
implements GridCoverage.Evaluator {
    private CoordinateReferenceSystem inputCRS;
    private MathTransform inputToGrid;
    private DirectPosition gridCoordinates;
    double[] values;
    private boolean nullIfOutside;
    private long wraparoundAxes;
    private double[] wraparoundExtent;
    private MathTransform gridToWraparound;
    private double[] periods;
    private Map<Integer, Long> slice;
    private CoordinateFormat coordinateFormat;

    protected DefaultEvaluator() {
    }

    @Override
    public final Map<Integer, Long> getDefaultSlice() {
        if (this.slice == null) {
            GridCoverage coverage = this.getCoverage();
            GridExtent extent = coverage.getGridGeometry().getExtent();
            this.slice = Containers.unmodifiable(extent.getSliceCoordinates());
        }
        return this.slice;
    }

    @Override
    public void setDefaultSlice(Map<Integer, Long> slice) {
        if (!Objects.equals(this.slice, slice)) {
            if (slice != null) {
                slice = Containers.unmodifiable(new TreeMap<Integer, Long>(slice));
                GridCoverage coverage = this.getCoverage();
                GridExtent extent = coverage.getGridGeometry().getExtent();
                int max = extent.getDimension() - 1;
                for (Map.Entry entry : slice.entrySet()) {
                    int dim = (Integer)entry.getKey();
                    ArgumentChecks.ensureBetween((String)"slice.key", (int)0, (int)max, (int)dim);
                    ArgumentChecks.ensureBetween((String)extent.getAxisIdentification(dim, dim).toString(), (long)extent.getLow(dim), (long)extent.getHigh(dim), (long)((Long)entry.getValue()));
                }
            }
            this.slice = slice;
            this.inputCRS = null;
            this.inputToGrid = null;
        }
    }

    @Override
    public boolean isWraparoundEnabled() {
        return this.wraparoundAxes != 0L;
    }

    @Override
    public void setWraparoundEnabled(boolean allow) {
        this.wraparoundAxes = 0L;
        if (allow) {
            try {
                GridCoverage coverage = this.getCoverage();
                WraparoundAxesFinder f = new WraparoundAxesFinder(coverage.getCoordinateReferenceSystem());
                this.periods = f.periods();
                if (this.periods != null) {
                    int i;
                    GridGeometry gridGeometry = coverage.getGridGeometry();
                    GridExtent extent = gridGeometry.getExtent();
                    MathTransform gridToCRS = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
                    this.gridToWraparound = MathTransforms.concatenate((MathTransform)gridToCRS, (MathTransform)f.preferredToSpecified.inverse());
                    Matrix m = this.gridToWraparound.derivative((DirectPosition)new DirectPositionView.Double(extent.getPointOfInterest(PixelInCell.CELL_CENTER)));
                    int j = this.periods.length;
                    while (--j >= 0) {
                        if (!(this.periods[j] > 0.0)) continue;
                        int i2 = Math.min(m.getNumCol(), 64);
                        while (--i2 >= 0) {
                            if (m.getElement(j, i2) == 0.0) continue;
                            this.wraparoundAxes |= 1L << i2;
                        }
                    }
                    this.wraparoundExtent = new double[Long.bitCount(this.wraparoundAxes) << 1];
                    long axes = this.wraparoundAxes;
                    int j2 = 0;
                    do {
                        i = Long.numberOfTrailingZeros(axes);
                        this.wraparoundExtent[j2++] = extent.getLow(i);
                        this.wraparoundExtent[j2++] = extent.getHigh(i);
                    } while ((axes &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                    assert (this.wraparoundExtent.length == j2) : j2;
                }
            }
            catch (TransformException e) {
                DefaultEvaluator.recoverableException("setWraparoundEnabled", (Exception)((Object)e));
            }
        }
    }

    @Override
    public boolean isNullIfOutside() {
        return this.nullIfOutside;
    }

    @Override
    public void setNullIfOutside(boolean flag) {
        this.nullIfOutside = flag;
    }

    @Override
    public double[] apply(DirectPosition point) throws CannotEvaluateException {
        try {
            double[] gridCoords = this.toGridPosition(point);
            IntFunction<PointOutsideCoverageException> ifOutside = this.nullIfOutside ? null : index -> this.pointOutsideCoverage(point);
            if (ValuesAtPointIterator.create(this.getCoverage(), gridCoords, 1, ifOutside).tryAdvance(t -> {
                this.values = t;
            })) {
                return this.values;
            }
        }
        catch (PointOutsideCoverageException ex) {
            throw ex;
        }
        catch (RuntimeException | TransformException | FactoryException ex) {
            throw new CannotEvaluateException(ex.getMessage(), ex);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Stream<double[]> stream(Collection<? extends DirectPosition> points, boolean parallel) {
        GridCoverage coverage = this.getCoverage();
        int dimension = coverage.gridGeometry.getDimension();
        double[] coordinates = ArraysExt.EMPTY_DOUBLE;
        CoordinateReferenceSystem crs = this.inputCRS;
        MathTransform toGrid = this.inputToGrid;
        int srcDim = toGrid == null ? 0 : toGrid.getSourceDimensions();
        int inputCoordinateOffset = 0;
        int firstCoordToTransform = 0;
        int numPointsToTransform = 0;
        try {
            void var13_19;
            for (DirectPosition directPosition : points) {
                if (crs != (crs = directPosition.getCoordinateReferenceSystem())) {
                    if (numPointsToTransform > 0) {
                        assert (toGrid.getTargetDimensions() == dimension);
                        toGrid.transform(coordinates, firstCoordToTransform, coordinates, firstCoordToTransform, numPointsToTransform);
                    }
                    inputCoordinateOffset = firstCoordToTransform += numPointsToTransform * dimension;
                    numPointsToTransform = 0;
                    toGrid = this.getInputToGrid(crs);
                    srcDim = toGrid.getSourceDimensions();
                }
                int offset = inputCoordinateOffset;
                if ((inputCoordinateOffset += srcDim) > coordinates.length) {
                    int n = firstCoordToTransform / dimension;
                    n = points.size() - n + numPointsToTransform;
                    coordinates = Arrays.copyOf(coordinates, Math.multiplyExact(n, Math.max(srcDim, dimension)) + offset);
                }
                for (int i = 0; i < srcDim; ++i) {
                    coordinates[offset++] = directPosition.getOrdinate(i);
                }
                ++numPointsToTransform;
            }
            if (numPointsToTransform > 0) {
                assert (toGrid.getTargetDimensions() == dimension);
                toGrid.transform(coordinates, firstCoordToTransform, coordinates, firstCoordToTransform, numPointsToTransform);
            }
            int numPoints = firstCoordToTransform / dimension + numPointsToTransform;
            this.postTransform(coordinates, 0, numPoints);
            if (this.nullIfOutside) {
                Object var13_17 = null;
            } else {
                List listOfPoints = points instanceof List ? (List)points : null;
                IntFunction<PointOutsideCoverageException> intFunction = index -> {
                    DirectPosition point = null;
                    if (listOfPoints != null) {
                        try {
                            point = (DirectPosition)listOfPoints.get(index);
                        }
                        catch (IndexOutOfBoundsException e) {
                            DefaultEvaluator.recoverableException("pointOutsideCoverage", e);
                        }
                    }
                    if (point != null) {
                        return this.pointOutsideCoverage(point);
                    }
                    return new PointOutsideCoverageException(Resources.format((short)37, "#" + index));
                };
            }
            return StreamSupport.stream(ValuesAtPointIterator.create(coverage, coordinates, numPoints, (IntFunction<PointOutsideCoverageException>)var13_19), parallel);
        }
        catch (CannotEvaluateException ex) {
            throw ex;
        }
        catch (RuntimeException | TransformException | FactoryException ex) {
            throw new CannotEvaluateException(ex.getMessage(), ex);
        }
    }

    @Override
    public FractionalGridCoordinates toGridCoordinates(DirectPosition point) throws TransformException {
        try {
            double[] gridCoords = this.toGridPosition(point);
            int dimension = this.inputToGrid.getTargetDimensions();
            return new FractionalGridCoordinates(ArraysExt.resize((double[])gridCoords, (int)dimension));
        }
        catch (FactoryException e) {
            throw new TransformException(e.getMessage(), (Throwable)e);
        }
    }

    final double[] toGridPosition(DirectPosition point) throws FactoryException, TransformException {
        double[] coordinates;
        this.gridCoordinates = this.getInputToGrid(point.getCoordinateReferenceSystem()).transform(point, this.gridCoordinates);
        int dimension = this.inputToGrid.getTargetDimensions();
        double[] gridCoords = dimension <= (coordinates = point.getCoordinate()).length ? coordinates : new double[dimension];
        this.inputToGrid.transform(coordinates, 0, gridCoords, 0, 1);
        this.postTransform(gridCoords, 0, 1);
        return gridCoords;
    }

    private void postTransform(double[] gridCoords, int offset, int numPoints) throws TransformException {
        if (this.wraparoundAxes == 0L) {
            return;
        }
        double[] twoPoints = null;
        int dimension = this.inputToGrid.getTargetDimensions();
        int dimOfWrap = this.gridToWraparound.getTargetDimensions();
        block0: while (--numPoints >= 0) {
            int axis;
            long mask;
            long axesToCheck = this.wraparoundAxes;
            long outsideAxes = 0L;
            int limitIndex = 0;
            do {
                block15: {
                    double limit;
                    block14: {
                        double d;
                        axis = Long.numberOfTrailingZeros(axesToCheck);
                        mask = 1L << axis;
                        double c = gridCoords[offset + axis];
                        limit = this.wraparoundExtent[limitIndex];
                        if (c < limit) break block14;
                        limit = this.wraparoundExtent[limitIndex + 1];
                        if (!(c > d)) break block15;
                    }
                    if (outsideAxes == 0L) {
                        if (twoPoints == null) {
                            twoPoints = new double[Math.max(dimension, dimOfWrap * 2)];
                        }
                        System.arraycopy(gridCoords, offset, twoPoints, 0, dimension);
                    }
                    twoPoints[axis] = limit;
                    outsideAxes |= mask;
                }
                limitIndex += 2;
            } while ((axesToCheck &= mask ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            assert (this.wraparoundExtent.length == limitIndex) : limitIndex;
            if (outsideAxes == 0L) continue;
            this.gridToWraparound.transform(twoPoints, 0, twoPoints, dimOfWrap, 1);
            this.gridToWraparound.transform(gridCoords, offset, twoPoints, 0, 1);
            axis = this.periods.length;
            while (--axis >= 0) {
                double period = this.periods[axis];
                if (!(period > 0.0)) continue;
                double shift = twoPoints[axis + dimOfWrap] - twoPoints[axis];
                shift = Math.copySign(Math.ceil(Math.abs(shift) / period), shift) * period;
                int n = axis;
                twoPoints[n] = twoPoints[n] + shift;
            }
            this.gridToWraparound.inverse().transform(twoPoints, 0, twoPoints, 0, 1);
            limitIndex = 0;
            do {
                double c;
                if (!((c = twoPoints[axis = Long.numberOfTrailingZeros(outsideAxes)]) < this.wraparoundExtent[limitIndex++])) {
                    int n = limitIndex++;
                    if (!(c > this.wraparoundExtent[n])) continue;
                }
                offset += dimension;
                continue block0;
            } while ((outsideAxes &= 1L << axis ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
            for (int i = 0; i < dimension; ++i) {
                double value = twoPoints[i];
                if (!Double.isNaN(value)) {
                    gridCoords[offset] = value;
                }
                ++offset;
            }
        }
    }

    private synchronized MathTransform getInputToGrid(CoordinateReferenceSystem crs) throws FactoryException, NoninvertibleTransformException {
        if (crs == this.inputCRS && this.inputToGrid != null) {
            return this.inputToGrid;
        }
        GridCoverage coverage = this.getCoverage();
        GridGeometry gridGeometry = coverage.getGridGeometry();
        MathTransform gridToCRS = gridGeometry.getGridToCRS(PixelInCell.CELL_CENTER);
        MathTransform crsToGrid = TranslatedTransform.resolveNaN(gridToCRS.inverse(), gridGeometry);
        if (crs != null) {
            CoordinateReferenceSystem stepCRS = coverage.getCoordinateReferenceSystem();
            GeographicBoundingBox areaOfInterest = gridGeometry.getGeographicExtent().orElse(null);
            try {
                CoordinateOperation op = CRS.findOperation((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)stepCRS, (GeographicBoundingBox)areaOfInterest);
                crsToGrid = MathTransforms.concatenate((MathTransform)op.getMathTransform(), (MathTransform)crsToGrid);
            }
            catch (FactoryException main) {
                Map<Integer, Long> slice = this.getDefaultSlice();
                try {
                    CoordinateOperation op = CRS.findOperation((CoordinateReferenceSystem)stepCRS, (CoordinateReferenceSystem)crs, (GeographicBoundingBox)areaOfInterest);
                    gridToCRS = MathTransforms.concatenate((MathTransform)gridToCRS, (MathTransform)op.getMathTransform());
                    TransformSeparator ts = new TransformSeparator(gridToCRS);
                    int crsDim = gridToCRS.getTargetDimensions();
                    int gridDim = gridToCRS.getSourceDimensions();
                    int[] mandatory = new int[gridDim];
                    int n = 0;
                    for (int i = 0; i < gridDim; ++i) {
                        if (slice.containsKey(i)) continue;
                        mandatory[n++] = i;
                    }
                    mandatory = ArraysExt.resize((int[])mandatory, (int)n);
                    ts.addSourceDimensions(mandatory);
                    ts.setSourceExpandable(true);
                    ts.addTargetDimensionRange(0, crsDim);
                    gridToCRS = ts.separate();
                    crsToGrid = gridToCRS.inverse();
                    mandatory = ts.getSourceDimensions();
                    int valueColumn = mandatory.length;
                    MatrixSIS m = Matrices.createZero((int)(gridDim + 1), (int)(valueColumn + 1));
                    m.setElement(gridDim, valueColumn, 1.0);
                    n = 0;
                    for (int j = 0; j < gridDim; ++j) {
                        if (Arrays.binarySearch(mandatory, j) >= 0) {
                            m.setElement(j, n++, 1.0);
                            continue;
                        }
                        Long value = slice.get(j);
                        if (value == null) {
                            GridExtent extent = gridGeometry.getExtent();
                            throw new FactoryException(Resources.format((short)50, crsDim, extent.getAxisIdentification(j, j), extent.getSize(j)));
                        }
                        m.setElement(j, valueColumn, (double)value.longValue());
                    }
                    crsToGrid = MathTransforms.concatenate((MathTransform)crsToGrid, (MathTransform)MathTransforms.linear((Matrix)m));
                }
                catch (RuntimeException | NoninvertibleTransformException | FactoryException ex) {
                    main.addSuppressed(ex);
                    throw main;
                }
            }
        }
        this.inputCRS = crs;
        this.inputToGrid = crsToGrid;
        return crsToGrid;
    }

    final synchronized PointOutsideCoverageException pointOutsideCoverage(DirectPosition point) {
        String details = null;
        StringBuilder buffer = new StringBuilder();
        GridCoverage coverage = this.getCoverage();
        GridExtent extent = coverage.gridGeometry.extent;
        if (extent != null) {
            try {
                int i;
                this.gridCoordinates = this.getInputToGrid(point.getCoordinateReferenceSystem()).transform(point, this.gridCoordinates);
                int axis = 0;
                long validMin = 0L;
                long validMax = 0L;
                double distance = 0.0;
                int dimension = Math.min(this.gridCoordinates.getDimension(), extent.getDimension());
                for (i = 0; i < dimension; ++i) {
                    long low = extent.getLow(i);
                    long high = extent.getHigh(i);
                    double c = this.gridCoordinates.getOrdinate(i);
                    double d = (double)low - c;
                    if (!(d > distance)) {
                        double d2;
                        d = c - (double)high;
                        if (!(d2 > distance)) continue;
                    }
                    axis = i;
                    validMin = low;
                    validMax = high;
                    distance = d;
                }
                if (distance > 0.0) {
                    block3: for (i = 0; i < dimension; ++i) {
                        if (i != 0) {
                            buffer.append(' ');
                        }
                        int s = buffer.length();
                        StringBuilders.trimFractionalPart((StringBuilder)buffer.append(this.gridCoordinates.getOrdinate(i)));
                        s = buffer.indexOf(".", s);
                        if (s < 0) continue;
                        while (++s < buffer.length()) {
                            if (buffer.charAt(s) == '0') continue;
                            buffer.setLength(s + 1);
                            continue block3;
                        }
                    }
                    details = Resources.format((short)21, extent.getAxisIdentification(axis, axis), validMin, validMax, buffer);
                }
            }
            catch (IllegalArgumentException | TransformException | FactoryException e) {
                DefaultEvaluator.recoverableException("pointOutsideCoverage", (Exception)e);
            }
        }
        buffer.setLength(0);
        if (this.coordinateFormat == null) {
            this.coordinateFormat = coverage.createCoordinateFormat();
        }
        this.coordinateFormat.format((Object)point, buffer);
        Object message = Resources.format((short)37, buffer);
        if (details != null) {
            message = (String)message + System.lineSeparator() + details;
        }
        return new PointOutsideCoverageException((String)message);
    }

    private static void recoverableException(String caller, Exception exception) {
        Logging.recoverableException((Logger)GridExtent.LOGGER, DefaultEvaluator.class, (String)caller, (Throwable)exception);
    }
}

