/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.pages;

import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.pages.SelfPasswordReset;
import org.apache.syncope.client.enduser.pages.SelfRegistration;
import org.apache.syncope.client.ui.commons.BaseLogin;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.client.ui.commons.panels.BaseSSOLoginFormPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class Login
extends BaseLogin {
    private static final long serialVersionUID = 5889157642852559004L;
    protected final BookmarkablePageLink<Void> selfPwdReset = new BookmarkablePageLink("self-pwd-reset", SelfPasswordReset.class);
    protected final BookmarkablePageLink<Void> selfRegistration;

    public Login(PageParameters parameters) {
        super(parameters);
        this.selfPwdReset.getPageParameters().add("domain", (Object)SyncopeEnduserSession.get().getDomain());
        this.selfPwdReset.setVisible(SyncopeEnduserSession.get().getPlatformInfo().isPwdResetAllowed());
        this.add(new Component[]{this.selfPwdReset.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
        this.selfRegistration = new BookmarkablePageLink("self-registration", SelfRegistration.class);
        this.selfRegistration.getPageParameters().add("domain", (Object)SyncopeEnduserSession.get().getDomain());
        this.selfRegistration.setVisible(SyncopeEnduserSession.get().getPlatformInfo().isSelfRegAllowed());
        this.add(new Component[]{this.selfRegistration.setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
    }

    protected Collection<Component> getLanguageOnChangeComponents() {
        return Stream.concat(super.getLanguageOnChangeComponents().stream(), List.of(this.selfRegistration, this.selfPwdReset).stream()).collect(Collectors.toList());
    }

    protected BaseSession getBaseSession() {
        return SyncopeEnduserSession.get();
    }

    protected List<BaseSSOLoginFormPanel> getSSOLoginFormPanels() {
        ArrayList<BaseSSOLoginFormPanel> ssoLoginFormPanels = new ArrayList<BaseSSOLoginFormPanel>();
        SyncopeWebApplication.get().getLookup().getSSOLoginFormPanels().forEach(ssoLoginFormPanel -> {
            try {
                ssoLoginFormPanels.add((BaseSSOLoginFormPanel)ssoLoginFormPanel.getConstructor(String.class, BaseSession.class).newInstance(new Object[]{"ssoLogin", SyncopeEnduserSession.get()}));
            }
            catch (Exception e) {
                LOG.error("Could not initialize the provided SSO login form panel", (Throwable)e);
            }
        });
        return ssoLoginFormPanels;
    }

    protected void sendError(String error) {
        SyncopeEnduserSession.get().error((Serializable)((Object)error));
    }

    protected void onAuthenticateSuccess(AjaxRequestTarget target) {
        this.continueToOriginalDestination();
        this.setResponsePage(this.getApplication().getHomePage());
    }

    protected void onAuthenticateFailure(AjaxRequestTarget target) {
        SyncopeEnduserSession.get().error((Serializable)((Object)this.getString("login-error")));
        this.notificationPanel.refresh((IPartialPageRequestHandler)target);
    }

    protected void authenticate(String username, String password, AjaxRequestTarget target) throws AccessControlException {
        if (SyncopeWebApplication.get().getAnonymousUser().equals(username) || SyncopeWebApplication.get().getAdminUser().equals(username)) {
            throw new AccessControlException("Illegal username");
        }
        if (SyncopeEnduserSession.get().authenticate(username, password)) {
            this.onAuthenticateSuccess(target);
        } else {
            this.onAuthenticateFailure(target);
        }
    }
}

