/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.schema;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import net.tirasa.connid.bundles.ad.ADConfiguration;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ad.ADConnector;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.schema.LdapSchema;
import net.tirasa.connid.bundles.ldap.schema.LdapSchemaBuilder;
import net.tirasa.connid.bundles.ldap.search.LdapInternalSearch;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.SchemaBuilder;

class ADSchemaBuilder
extends LdapSchemaBuilder {
    private static final Log LOG = Log.getLog(ADSchemaBuilder.class);
    private static final String[] ATTRIBUTES_TO_GET = new String[]{"maycontain", "systemmaycontain", "mustcontain", "systemmustcontain"};

    public ADSchemaBuilder(ADConnection conn) {
        super((LdapConnection)conn);
    }

    protected void buildSchema() {
        SchemaBuilder schemaBld = new SchemaBuilder(ADConnector.class);
        this.build(ObjectClass.ACCOUNT_NAME, schemaBld);
        this.build(ObjectClass.GROUP_NAME, schemaBld);
        this.build(ObjectClass.ALL_NAME, schemaBld);
        this.build(LdapSchema.ANY_OBJECT_NAME, schemaBld);
        this.schema = schemaBld.build();
    }

    private void build(String oname, SchemaBuilder schemaBld) {
        String[] stringArray;
        ADConfiguration conf = (ADConfiguration)this.conn.getConfiguration();
        StringBuilder filter = new StringBuilder();
        SearchControls searchCtls = LdapInternalSearch.createDefaultSearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(ATTRIBUTES_TO_GET);
        if (oname.equalsIgnoreCase(ObjectClass.ACCOUNT_NAME)) {
            stringArray = conf.getAccountObjectClasses();
        } else if (oname.equalsIgnoreCase(ObjectClass.GROUP_NAME)) {
            stringArray = conf.getGroupObjectClasses();
        } else if (oname.equalsIgnoreCase(LdapSchema.ANY_OBJECT_NAME)) {
            stringArray = conf.getAnyObjectClasses();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = oname;
        }
        for (String string : stringArray) {
            filter.append("(lDAPDisplayName=").append(string).append(")");
        }
        filter.insert(0, "(&(|").append(")(objectClass=classSchema))");
        LdapContext ctx = this.conn.getInitialContext();
        HashSet<String> schemaNames = new HashSet<String>();
        if (oname.equalsIgnoreCase(ObjectClass.ACCOUNT_NAME)) {
            schemaNames.add(conf.getUidAttribute());
        } else if (oname.equalsIgnoreCase(ObjectClass.GROUP_NAME)) {
            schemaNames.add(conf.getGidAttribute());
        } else if (oname.equalsIgnoreCase(LdapSchema.ANY_OBJECT_NAME)) {
            schemaNames.add(conf.getAoidAttribute());
        } else {
            schemaNames.add("objectGUID");
        }
        String schemaConfigurationPath = "CN=Schema,CN=Configuration";
        for (String suffix : conf.getBaseContexts()) {
            try {
                NamingEnumeration<SearchResult> oclasses = ctx.search("CN=Schema,CN=Configuration," + suffix, filter.toString(), searchCtls);
                while (oclasses.hasMoreElements()) {
                    SearchResult oclass = oclasses.next();
                    schemaNames.addAll(this.getObjectSchemaNames(oclass));
                }
            }
            catch (NamingException e) {
                LOG.error((Throwable)e, "Error retrieving schema names from {0}", new Object[]{suffix});
            }
        }
        schemaNames.remove("ntSecurityDescriptor");
        schemaNames.remove("lockoutTime");
        schemaNames.remove("pwdLastSet");
        schemaNames.remove("primaryGroupDN");
        ObjectClassInfoBuilder objectClassInfoBuilder = new ObjectClassInfoBuilder();
        objectClassInfoBuilder.setType(oname);
        objectClassInfoBuilder.setContainer(false);
        objectClassInfoBuilder.addAllAttributeInfo(this.createAttrInfos(schemaNames));
        objectClassInfoBuilder.addAttributeInfo(AttributeInfoBuilder.build((String)"userCannotChangePassword", Boolean.class));
        objectClassInfoBuilder.addAttributeInfo(AttributeInfoBuilder.build((String)"lockoutTime", Boolean.class));
        objectClassInfoBuilder.addAttributeInfo(AttributeInfoBuilder.build((String)"pwdLastSet", Boolean.class));
        objectClassInfoBuilder.addAttributeInfo(AttributeInfoBuilder.build((String)"passwordNeverExpires", Boolean.class));
        objectClassInfoBuilder.addAttributeInfo(AttributeInfoBuilder.build((String)"passwordNotRequired", Boolean.class));
        objectClassInfoBuilder.addAttributeInfo(AttributeInfoBuilder.build((String)"primaryGroupDN", String.class));
        ObjectClassInfo oci = objectClassInfoBuilder.build();
        schemaBld.defineObjectClass(oci);
    }

    private Set<String> getObjectSchemaNames(SearchResult oclass) throws NamingException {
        HashSet<String> schemaNames = new HashSet<String>();
        for (String attrName : ATTRIBUTES_TO_GET) {
            Attribute attr = oclass.getAttributes().get(attrName);
            if (attr == null) continue;
            NamingEnumeration<?> en = attr.getAll();
            while (en.hasMoreElements()) {
                String elem = (String)en.nextElement();
                if (!StringUtil.isNotBlank((String)elem)) continue;
                schemaNames.add(elem.trim());
            }
        }
        return schemaNames;
    }

    private List<AttributeInfo> createAttrInfos(Set<String> schemaNames) {
        ArrayList<AttributeInfo> infos = new ArrayList<AttributeInfo>();
        for (String schemaName : schemaNames) {
            infos.add(this.handleAttribute(schemaName));
        }
        return infos;
    }

    private AttributeInfo handleAttribute(String displayName) {
        String IS_SINGLE_VALUE = "isSingleValued";
        String SYSTEM_ONLY = "systemOnly";
        String LDAP_DISPLAY_NAME = "lDAPDisplayName";
        EnumSet<AttributeInfo.Flags> flags = EnumSet.noneOf(AttributeInfo.Flags.class);
        boolean binary = this.conn.isBinarySyntax(displayName);
        boolean objectClass = displayName == null || "objectClass".equalsIgnoreCase(displayName);
        LdapContext ctx = this.conn.getInitialContext();
        String[] baseContexts = this.conn.getConfiguration().getBaseContexts();
        SearchControls searchCtls = LdapInternalSearch.createDefaultSearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(new String[]{"isSingleValued", "systemOnly"});
        Attributes attributes = null;
        for (int i = 0; attributes == null && i < baseContexts.length; ++i) {
            StringBuilder dn = new StringBuilder();
            dn.append("cn=schema, cn=configuration,").append(baseContexts[i]);
            try {
                NamingEnumeration<SearchResult> result = ctx.search(dn.toString(), "lDAPDisplayName=" + displayName, searchCtls);
                if (result == null || !result.hasMoreElements()) continue;
                attributes = result.next().getAttributes();
                continue;
            }
            catch (NamingException e) {
                LOG.error((Throwable)e, "Error retrieving attributes for {0}", new Object[]{dn});
            }
        }
        if (attributes != null) {
            Attribute isSingle = attributes.get("isSingleValued");
            try {
                if (isSingle == null || isSingle.get() == null || "false".equalsIgnoreCase(isSingle.get().toString())) {
                    flags.add(AttributeInfo.Flags.MULTIVALUED);
                }
            }
            catch (NamingException e) {
                LOG.error((Throwable)e, "Failure retrieving attribute isSingleValued", new Object[0]);
            }
            Attribute systemOnly = attributes.get("systemOnly");
            try {
                if (systemOnly != null && systemOnly.get() != null && "true".equalsIgnoreCase(systemOnly.get().toString()) || objectClass) {
                    flags.add(AttributeInfo.Flags.NOT_CREATABLE);
                    flags.add(AttributeInfo.Flags.NOT_UPDATEABLE);
                }
            }
            catch (NamingException e) {
                LOG.error((Throwable)e, "Failure retrieving attribute systemOnly", new Object[0]);
            }
        }
        return AttributeInfoBuilder.build((String)displayName, binary ? byte[].class : String.class, flags);
    }
}

