/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.util.Assert;
import java.io.IOException;

public class GroupZapNodeMessage
extends AbstractGroupMessage {
    public static final int ZAP_NODE_REQUEST = 0;
    private int zapNodeType;
    private String reason;
    private long[] weights;

    public GroupZapNodeMessage() {
        super(-1);
    }

    public GroupZapNodeMessage(int type, int zapNodeType, String reason, long[] weights) {
        super(type);
        this.reason = reason;
        this.zapNodeType = zapNodeType;
        this.weights = weights;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        Assert.assertEquals(0, this.getType());
        this.zapNodeType = in.readInt();
        this.reason = in.readString();
        this.weights = new long[in.readInt()];
        for (int i = 0; i < this.weights.length; ++i) {
            this.weights[i] = in.readLong();
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        Assert.assertEquals(0, this.getType());
        out.writeInt(this.zapNodeType);
        out.writeString(this.reason);
        out.writeInt(this.weights.length);
        for (long weight : this.weights) {
            out.writeLong(weight);
        }
    }

    public String toString() {
        return "GroupZapNodeMessage [ " + this.zapNodeType + " , " + this.reason + " , weights = " + this.toString(this.weights) + " ]";
    }

    private String toString(long[] l) {
        if (l == null) {
            return "null";
        }
        if (l.length == 0) {
            return "empty";
        }
        StringBuffer sb = new StringBuffer();
        for (long element : l) {
            sb.append(String.valueOf(element)).append(",");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String getReason() {
        return this.reason;
    }

    public int getZapNodeType() {
        return this.zapNodeType;
    }

    public long[] getWeights() {
        return this.weights;
    }
}

