/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import java.util.LinkedHashSet;
import java.util.Set;

public class CallbackPortRange {
    public static final int SYSTEM_ASSIGNED = 0;

    public static Set<Integer> expandRange(String propValue) {
        propValue = propValue.trim().replaceAll("\\s", "");
        String[] parts = propValue.split(",");
        LinkedHashSet<Integer> range = new LinkedHashSet<Integer>();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            if (part.indexOf("-") > 0) {
                int high;
                String[] lowHigh = part.split("-");
                if (lowHigh.length != 2) {
                    throw new IllegalArgumentException("unparseable port range: " + part);
                }
                int low = Integer.parseInt(lowHigh[0]);
                if (low > (high = Integer.parseInt(lowHigh[1]))) {
                    throw new IllegalArgumentException("Invalid range: " + part);
                }
                for (int i = low; i <= high; ++i) {
                    range.add(i);
                }
                continue;
            }
            range.add(Integer.parseInt(part));
        }
        if ((range.contains(-1) || range.contains(0)) && range.size() != 1) {
            throw new IllegalArgumentException("port range containing special values must be size 1: " + propValue);
        }
        return range;
    }
}

