/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaOperationsProcessEngineBuild
implements Command<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaOperationsProcessEngineBuild.class);

    public Void execute(CommandContext commandContext) {
        SchemaManager schemaManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getSchemaManager();
        String databaseSchemaUpdate = CommandContextUtil.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        LOGGER.debug("Executing schema management with setting {}", (Object)databaseSchemaUpdate);
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                schemaManager.schemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            schemaManager.schemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            schemaManager.schemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            schemaManager.schemaUpdate();
        }
        return null;
    }
}

