/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging.config;

import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.web.Log4jServletContextListener;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.logging.web.LoggingConfigurationEndpoint;
import org.apereo.cas.logging.web.ThreadContextMDCServletFilter;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Core)
@AutoConfiguration
public class CasLoggingConfiguration {

    @ConditionalOnClass(value={LoggerContext.class})
    @Configuration(value="CasLog4jConfiguration", proxyBeanMethods=false)
    public static class CasLog4jConfiguration {
        @Bean
        @ConditionalOnAvailableEndpoint
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LoggingConfigurationEndpoint loggingConfigurationEndpoint(CasConfigurationProperties casProperties, Environment environment, ResourceLoader resourceLoader) {
            return new LoggingConfigurationEndpoint(casProperties, resourceLoader, environment);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServletListenerRegistrationBean<Log4jServletContextListener> log4jServletContextListener() {
            ServletListenerRegistrationBean bean = new ServletListenerRegistrationBean();
            bean.setEnabled(true);
            bean.setListener((EventListener)new Log4jServletContextListener());
            return bean;
        }
    }

    @ConditionalOnBean(value={TicketRegistry.class})
    public static class CasMdcLoggingConfiguration {
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FilterRegistrationBean<ThreadContextMDCServletFilter> threadContextMDCServletFilter(CasConfigurationProperties casProperties, @Qualifier(value="defaultTicketRegistrySupport") ObjectProvider<TicketRegistrySupport> ticketRegistrySupport, @Qualifier(value="ticketGrantingTicketCookieGenerator") ObjectProvider<CasCookieBuilder> ticketGrantingTicketCookieGenerator) {
            ThreadContextMDCServletFilter filter = new ThreadContextMDCServletFilter(ticketRegistrySupport, ticketGrantingTicketCookieGenerator);
            HashMap initParams = new HashMap();
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)filter);
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setInitParameters(initParams);
            bean.setName("threadContextMDCServletFilter");
            bean.setOrder(-2147483647);
            bean.setEnabled(casProperties.getLogging().isMdcEnabled());
            return bean;
        }
    }
}

