/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.mdui;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.mdui.MetadataResolverAdapter;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterChain;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractMetadataResolverAdapter
implements MetadataResolverAdapter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMetadataResolverAdapter.class);
    @Generated
    private final Object $lock = new Object[0];
    protected Map<Resource, MetadataFilterChain> metadataResources;
    protected boolean requireValidMetadata = true;
    protected OpenSamlConfigBean configBean;
    private ChainingMetadataResolver metadataResolver;

    protected AbstractMetadataResolverAdapter() {
        this(new HashMap<Resource, MetadataFilterChain>(0));
    }

    protected AbstractMetadataResolverAdapter(Map<Resource, MetadataFilterChain> metadataResources) {
        this.metadataResources = metadataResources;
    }

    @Override
    public EntityDescriptor getEntityDescriptorForEntityId(String entityId) {
        return (EntityDescriptor)FunctionUtils.doUnchecked(() -> {
            CriteriaSet criterions = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityId)});
            if (this.metadataResolver != null) {
                return this.metadataResolver.resolveSingle(criterions);
            }
            return null;
        });
    }

    public void buildMetadataResolverAggregate() {
        this.buildMetadataResolverAggregate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildMetadataResolverAggregate(String entityId) {
        Object object = this.$lock;
        synchronized (object) {
            LOGGER.trace("Building metadata resolver aggregate");
            this.metadataResolver = new ChainingMetadataResolver();
            Set<Map.Entry<Resource, MetadataFilterChain>> entries = this.metadataResources.entrySet();
            ArrayList resolvers = new ArrayList(entries.size());
            entries.forEach(entry -> {
                Resource resource = (Resource)entry.getKey();
                LOGGER.debug("Loading [{}]", (Object)resource.getFilename());
                resolvers.addAll(this.loadMetadataFromResource((MetadataFilter)entry.getValue(), resource, entityId));
            });
            FunctionUtils.doUnchecked(u -> {
                this.metadataResolver.setId(ChainingMetadataResolver.class.getCanonicalName());
                this.metadataResolver.setResolvers((List)resolvers);
                LOGGER.debug("Collected metadata from [{}] resolvers(s). Initializing aggregate resolver...", (Object)resolvers.size());
                this.metadataResolver.initialize();
                LOGGER.info("Metadata aggregate initialized successfully.");
            }, (Object[])new Object[0]);
        }
    }

    protected InputStream getResourceInputStream(Resource resource, String entityId) throws IOException {
        LOGGER.debug("Locating metadata resource from input stream.");
        if (!resource.exists() || !resource.isReadable()) {
            throw new FileNotFoundException("Resource does not exist or is unreadable");
        }
        return resource.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<MetadataResolver> loadMetadataFromResource(MetadataFilter metadataFilter, Resource resource, String entityId) {
        LOGGER.debug("Evaluating metadata resource [{}]", (Object)resource.getFilename());
        try (InputStream in = this.getResourceInputStream(resource, entityId);){
            if (in.available() > 0) {
                LOGGER.debug("Parsing [{}]", (Object)resource.getFilename());
                Document document = this.configBean.getParserPool().parse(in);
                List<MetadataResolver> list = this.buildSingleMetadataResolver(metadataFilter, resource, document);
                return list;
            }
            LOGGER.warn("Input stream from resource [{}] appears empty. Moving on...", (Object)resource.getFilename());
            return new ArrayList<MetadataResolver>(0);
        }
        catch (Exception e) {
            LoggingUtils.warn((Logger)LOGGER, (String)"Could not retrieve input stream from resource. Moving on...", (Throwable)e);
        }
        return new ArrayList<MetadataResolver>(0);
    }

    private List<MetadataResolver> buildSingleMetadataResolver(MetadataFilter metadataFilterChain, Resource resource, Document document) {
        Element metadataRoot = document.getDocumentElement();
        DOMMetadataResolver metadataProvider = new DOMMetadataResolver(metadataRoot);
        metadataProvider.setParserPool(this.configBean.getParserPool());
        metadataProvider.setFailFastInitialization(true);
        metadataProvider.setRequireValidMetadata(this.requireValidMetadata);
        metadataProvider.setId(metadataProvider.getClass().getCanonicalName());
        if (metadataFilterChain != null) {
            metadataProvider.setMetadataFilter(metadataFilterChain);
        }
        LOGGER.debug("Initializing metadata resolver for [{}]", (Object)resource);
        FunctionUtils.doUnchecked(u -> metadataProvider.initialize(), (Object[])new Object[0]);
        ArrayList<MetadataResolver> resolvers = new ArrayList<MetadataResolver>(1);
        resolvers.add((MetadataResolver)metadataProvider);
        return resolvers;
    }

    @Generated
    public void setMetadataResources(Map<Resource, MetadataFilterChain> metadataResources) {
        this.metadataResources = metadataResources;
    }

    @Generated
    public void setRequireValidMetadata(boolean requireValidMetadata) {
        this.requireValidMetadata = requireValidMetadata;
    }

    @Generated
    public void setConfigBean(OpenSamlConfigBean configBean) {
        this.configBean = configBean;
    }

    @Generated
    public void setMetadataResolver(ChainingMetadataResolver metadataResolver) {
        this.metadataResolver = metadataResolver;
    }
}

