/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;
import org.apache.datasketches.quantiles.QuantilesDoublesUnion;
import org.apache.datasketches.quantiles.QuantilesDoublesUnionBuilder;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DoublesUnionBuilderTest {
    @Test
    public void checkBuilds() {
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            qs1.update((double)i);
        }
        int bytes = qs1.getCurrentCompactSerializedSizeBytes();
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[bytes]);
        qs1.putIntoMemorySegment(dstSeg);
        MemorySegment srcSeg = dstSeg;
        QuantilesDoublesUnionBuilder bldr = new QuantilesDoublesUnionBuilder();
        bldr.setMaxK(128);
        QuantilesDoublesUnion union = bldr.build();
        union = QuantilesDoublesUnion.heapify((MemorySegment)srcSeg);
        UpdatableQuantilesDoublesSketch qs2 = union.getResult();
        Assert.assertEquals((int)qs1.getCurrentCompactSerializedSizeBytes(), (int)qs2.getCurrentCompactSerializedSizeBytes());
        union = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs2);
        UpdatableQuantilesDoublesSketch qs3 = union.getResult();
        Assert.assertEquals((int)qs2.getCurrentCompactSerializedSizeBytes(), (int)qs3.getCurrentCompactSerializedSizeBytes());
        Assert.assertFalse((qs2 == qs3 ? 1 : 0) != 0);
    }

    @Test
    public void checkDeprecated1() {
        UpdatableQuantilesDoublesSketch qs1 = QuantilesDoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            qs1.update((double)i);
        }
        int bytes = qs1.getCurrentCompactSerializedSizeBytes();
        MemorySegment dstSeg = MemorySegment.ofArray(new byte[bytes]);
        qs1.putIntoMemorySegment(dstSeg);
        MemorySegment srcSeg = dstSeg;
        QuantilesDoublesUnionBuilder bldr = new QuantilesDoublesUnionBuilder();
        bldr.setMaxK(128);
        QuantilesDoublesUnion union = bldr.build();
        union = QuantilesDoublesUnion.heapify((MemorySegment)srcSeg);
        UpdatableQuantilesDoublesSketch qs2 = union.getResult();
        Assert.assertEquals((int)qs1.getCurrentCompactSerializedSizeBytes(), (int)qs2.getCurrentCompactSerializedSizeBytes());
        Assert.assertEquals((int)qs1.getCurrentUpdatableSerializedSizeBytes(), (int)qs2.getCurrentUpdatableSerializedSizeBytes());
        union = QuantilesDoublesUnion.heapify((QuantilesDoublesSketch)qs2);
        UpdatableQuantilesDoublesSketch qs3 = union.getResult();
        Assert.assertEquals((int)qs2.getCurrentCompactSerializedSizeBytes(), (int)qs3.getCurrentCompactSerializedSizeBytes());
        Assert.assertEquals((int)qs2.getCurrentUpdatableSerializedSizeBytes(), (int)qs3.getCurrentUpdatableSerializedSizeBytes());
        Assert.assertFalse((qs2 == qs3 ? 1 : 0) != 0);
    }

    @Test
    public void printlnTest() {
        DoublesUnionBuilderTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
    }
}

