/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core.ranges;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.AdditiveValue;
import com.google.uzaygezen.core.Pow2LengthBitSetRange;
import com.google.uzaygezen.core.ranges.BigIntegerRange;
import com.google.uzaygezen.core.ranges.Range;
import com.google.uzaygezen.core.ranges.RangeHome;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RangeUtil {
    public static <T, V extends AdditiveValue<V>, R> void overlapSum(List<R> x, List<? extends List<R>> y, RangeHome<T, V, R> rangeHome, V sum) {
        for (List<R> yElement : y) {
            sum.add(rangeHome.overlap(x, yElement));
        }
    }

    public static <T, V, R> List<R> toOrthotope(List<Pow2LengthBitSetRange> pow2LengthOrthotope, RangeHome<T, V, R> rangeHome) {
        ArrayList<R> result = new ArrayList<R>(pow2LengthOrthotope.size());
        for (Pow2LengthBitSetRange bitSetRange : pow2LengthOrthotope) {
            result.add(rangeHome.toRange(bitSetRange));
        }
        return Collections.unmodifiableList(result);
    }

    public static <T, V, R extends Range<T, V>> boolean contains(List<R> orthotope, List<T> point) {
        int n = point.size();
        Preconditions.checkArgument((orthotope.size() == n ? 1 : 0) != 0, (Object)"dimensionality mismatch");
        for (int i = 0; i < n; ++i) {
            if (((Range)orthotope.get(i)).contains(point.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsBigInteger(List<BigIntegerRange> orthotope, List<BigInteger> point) {
        int n = point.size();
        Preconditions.checkArgument((orthotope.size() == n ? 1 : 0) != 0, (Object)"dimensionality mismatch");
        for (int i = 0; i < n; ++i) {
            if (orthotope.get(i).getStart().compareTo(point.get(i)) <= 0 && orthotope.get(i).getEnd().compareTo(point.get(i)) > 0) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(int[][] orthotope, int[] point) {
        int n = point.length;
        Preconditions.checkArgument((orthotope.length == n ? 1 : 0) != 0, (Object)"dimensionality mismatch");
        for (int i = 0; i < n; ++i) {
            Preconditions.checkArgument((orthotope[i].length == 2 ? 1 : 0) != 0);
            if (!(orthotope[i][0] > point[i] | orthotope[i][1] <= point[i])) continue;
            return false;
        }
        return true;
    }
}

