/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl.types;

import java.math.BigDecimal;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class BigDecimalType
implements VariableType {
    public static final String TYPE_NAME = "bigdecimal";

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public Object getValue(ValueFields valueFields) {
        BigDecimal bigDecimal = null;
        String textValue = valueFields.getTextValue();
        if (textValue != null && !textValue.isEmpty()) {
            bigDecimal = new BigDecimal(textValue);
        }
        return bigDecimal;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value != null) {
            valueFields.setTextValue(((BigDecimal)value).toPlainString());
        } else {
            valueFields.setTextValue(null);
        }
    }

    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return BigDecimal.class.isAssignableFrom(value.getClass());
    }
}

