/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.resources.ConnectorWizardBuilder;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.rest.RestClient;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ConnidLocations
extends DirectoryPanel<Serializable, Serializable, ConnidLocationsDataProvider, RestClient> {
    private static final long serialVersionUID = -1328140415494501001L;
    @SpringBean
    protected ConnectorRestClient connectorRestClient;

    public ConnidLocations(String id, Builder builder) {
        super(id, (DirectoryPanel.Builder)builder);
        this.disableCheckBoxes();
        this.setShowResultPanel(true);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
    }

    protected ConnidLocationsDataProvider dataProvider() {
        return new ConnidLocationsDataProvider(this.rows);
    }

    protected String paginatorRowsKey() {
        return "dynRealm.paginator.rows";
    }

    protected List<IColumn<Serializable, String>> getColumns() {
        ArrayList<IColumn<Serializable, String>> columns = new ArrayList<IColumn<Serializable, String>>();
        columns.add((IColumn<Serializable, String>)new AbstractColumn<Serializable, String>((IModel)new ResourceModel("key"), "key"){

            public void populateItem(Item<ICellPopulator<Serializable>> cellItem, String componentId, IModel<Serializable> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((Serializable)rowModel.getObject()).toString()))});
            }
        });
        return columns;
    }

    public ActionsPanel<Serializable> getActions(IModel<Serializable> model) {
        ActionsPanel panel = super.getActions(model);
        panel.add((ActionLink)new ActionLink<Serializable>(){
            private static final long serialVersionUID = 293293495682202660L;

            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                ConnInstanceTO modelObject = new ConnInstanceTO();
                modelObject.setLocation((String)((Object)ignore));
                CompoundPropertyModel model = new CompoundPropertyModel((Object)modelObject);
                ConnidLocations.this.modal.setFormModel((Serializable)model);
                target.add(new Component[]{ConnidLocations.this.modal.setContent((ModalPanel)new ConnectorWizardBuilder(modelObject, ConnidLocations.this.connectorRestClient, ConnidLocations.this.pageRef).build("content", AjaxWizard.Mode.CREATE))});
                ConnidLocations.this.modal.header((IModel)new Model((Serializable)((Object)MessageFormat.format(ConnidLocations.this.getString("connector.new"), ignore))));
                ConnidLocations.this.modal.show(true);
            }
        }, ActionLink.ActionType.CREATE, String.format("%s", "CONNECTOR_CREATE"));
        return panel;
    }

    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    protected static class ConnidLocationsDataProvider
    extends DirectoryDataProvider<Serializable> {
        private static final long serialVersionUID = 3161906945317209169L;

        public ConnidLocationsDataProvider(int paginatorRows) {
            super(paginatorRows);
        }

        public Iterator<String> iterator(long first, long count) {
            ArrayList result = new ArrayList(SyncopeConsoleSession.get().getPlatformInfo().getConnIdLocations());
            return result.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return SyncopeConsoleSession.get().getPlatformInfo().getConnIdLocations().size();
        }

        public IModel<Serializable> model(Serializable object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<Serializable, Serializable, RestClient> {
        private static final long serialVersionUID = 4448348557808690524L;

        public Builder(PageReference pageRef) {
            super(null, pageRef);
        }

        protected WizardMgtPanel<Serializable> newInstance(String id, boolean wizardInModal) {
            return new ConnidLocations(id, this);
        }
    }
}

