/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.catalog;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.ticket.BaseTicketCatalogConfigurer;
import org.apereo.cas.ticket.ProxyGrantingTicketImpl;
import org.apereo.cas.ticket.ProxyTicketImpl;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketImpl;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.TicketDefinitionProperties;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.TransientSessionTicketImpl;
import org.apereo.cas.ticket.catalog.CasTicketCatalogConfigurationValuesProvider;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ConfigurableApplicationContext;

public class DefaultTicketCatalogConfigurer
extends BaseTicketCatalogConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTicketCatalogConfigurer.class);
    protected final CasConfigurationProperties casProperties;
    protected final ConfigurableApplicationContext applicationContext;
    private final ObjectProvider<CasTicketCatalogConfigurationValuesProvider> configurationValuesProvider;
    private final int order = Integer.MIN_VALUE;

    public final void configureTicketCatalog(TicketCatalog plan, CasConfigurationProperties casProperties) {
        LOGGER.trace("Registering CAS ticket definitions...");
        this.buildAndRegisterProxyTicketDefinition(plan, this.buildTicketDefinition(plan, "PT", ProxyTicket.class, ProxyTicketImpl.class, Integer.MIN_VALUE));
        this.buildAndRegisterServiceTicketDefinition(plan, this.buildTicketDefinition(plan, "ST", ServiceTicket.class, ServiceTicketImpl.class, Integer.MIN_VALUE));
        this.buildAndRegisterProxyGrantingTicketDefinition(plan, this.buildTicketDefinition(plan, "PGT", ProxyGrantingTicket.class, ProxyGrantingTicketImpl.class, Integer.MAX_VALUE));
        this.buildAndRegisterTicketGrantingTicketDefinition(plan, this.buildTicketDefinition(plan, "TGT", TicketGrantingTicket.class, TicketGrantingTicketImpl.class, Integer.MAX_VALUE));
        this.buildAndRegisterTransientSessionTicketDefinition(plan, this.buildTicketDefinition(plan, "TST", TransientSessionTicket.class, TransientSessionTicketImpl.class, Integer.MAX_VALUE));
    }

    protected void buildAndRegisterProxyGrantingTicketDefinition(TicketCatalog plan, TicketDefinition ticketDefinition) {
        this.configurationValuesProvider.ifAvailable(provider -> {
            TicketDefinitionProperties properties = ticketDefinition.getProperties();
            properties.setCascadeRemovals(provider.getProxyGrantingTicketCascadeRemovals().apply(this.applicationContext).booleanValue());
            properties.setStorageName(provider.getProxyGrantingTicketStorageName().apply(this.casProperties));
            properties.setStorageTimeout(provider.getProxyGrantingTicketStorageTimeout().apply(this.applicationContext).longValue());
        });
        this.registerTicketDefinition(plan, ticketDefinition);
    }

    protected void buildAndRegisterProxyTicketDefinition(TicketCatalog plan, TicketDefinition ticketDefinition) {
        this.configurationValuesProvider.ifAvailable(provider -> {
            TicketDefinitionProperties properties = ticketDefinition.getProperties();
            properties.setStorageName(provider.getProxyTicketStorageName().apply(this.casProperties));
            properties.setStorageTimeout(provider.getProxyTicketStorageTimeout().apply(this.applicationContext).longValue());
        });
        this.registerTicketDefinition(plan, ticketDefinition);
    }

    protected void buildAndRegisterServiceTicketDefinition(TicketCatalog plan, TicketDefinition ticketDefinition) {
        this.configurationValuesProvider.ifAvailable(provider -> {
            TicketDefinitionProperties properties = ticketDefinition.getProperties();
            properties.setStorageName(provider.getServiceTicketStorageName().apply(this.casProperties));
            properties.setStorageTimeout(provider.getServiceTicketStorageTimeout().apply(this.applicationContext).longValue());
        });
        this.registerTicketDefinition(plan, ticketDefinition);
    }

    protected void buildAndRegisterTicketGrantingTicketDefinition(TicketCatalog plan, TicketDefinition ticketDefinition) {
        this.configurationValuesProvider.ifAvailable(provider -> {
            TicketDefinitionProperties properties = ticketDefinition.getProperties();
            properties.setCascadeRemovals(provider.getTicketGrantingTicketCascadeRemovals().apply(this.applicationContext).booleanValue());
            properties.setStorageName(provider.getTicketGrantingTicketStorageName().apply(this.casProperties));
            properties.setStorageTimeout(provider.getTicketGrantingTicketStorageTimeout().apply(this.applicationContext).longValue());
        });
        this.registerTicketDefinition(plan, ticketDefinition);
    }

    protected void buildAndRegisterTransientSessionTicketDefinition(TicketCatalog plan, TicketDefinition ticketDefinition) {
        this.configurationValuesProvider.ifAvailable(provider -> {
            TicketDefinitionProperties properties = ticketDefinition.getProperties();
            properties.setExcludeFromCascade(true);
            properties.setStorageName(provider.getTransientSessionStorageName().apply(this.casProperties));
            properties.setStorageTimeout(provider.getTransientSessionStorageTimeout().apply(this.applicationContext).longValue());
        });
        this.registerTicketDefinition(plan, ticketDefinition);
    }

    @Generated
    public DefaultTicketCatalogConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, ObjectProvider<CasTicketCatalogConfigurationValuesProvider> configurationValuesProvider) {
        this.casProperties = casProperties;
        this.applicationContext = applicationContext;
        this.configurationValuesProvider = configurationValuesProvider;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }
}

