/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.CaseServiceTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmmn.CaseInstanceService;
import org.flowable.engine.impl.delegate.SubProcessActivityBehavior;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.EntityLinkUtil;
import org.flowable.engine.impl.util.IOParameterUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseTaskActivityBehavior
extends AbstractBpmnActivityBehavior
implements SubProcessActivityBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaseTaskActivityBehavior.class);
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(DelegateExecution execution) {
        Expression expression;
        String idVariableName;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        CaseServiceTask caseServiceTask = (CaseServiceTask)executionEntity.getCurrentFlowElement();
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        CaseInstanceService caseInstanceService = processEngineConfiguration.getCaseInstanceService();
        if (caseInstanceService == null) {
            throw new FlowableException("To use the case service task a CaseInstanceService implementation needs to be available in the process engine configuration");
        }
        String businessKey = null;
        if (!StringUtils.isEmpty((CharSequence)caseServiceTask.getBusinessKey())) {
            Expression expression2 = expressionManager.createExpression(caseServiceTask.getBusinessKey());
            businessKey = expression2.getValue((VariableContainer)execution).toString();
        } else if (caseServiceTask.isInheritBusinessKey()) {
            ExecutionEntity processInstance = (ExecutionEntity)executionEntityManager.findById(execution.getProcessInstanceId());
            businessKey = processInstance.getBusinessKey();
        }
        String caseInstanceName = null;
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getCaseInstanceName())) {
            Expression caseInstanceNameExpression = expressionManager.createExpression(caseServiceTask.getCaseInstanceName());
            caseInstanceName = caseInstanceNameExpression.getValue((VariableContainer)execution).toString();
        }
        HashMap<String, Object> inParameters = new HashMap<String, Object>();
        IOParameterUtil.processInParameters(caseServiceTask.getInParameters(), (VariableContainer)execution, inParameters::put, inParameters::put, expressionManager);
        String caseInstanceId = caseInstanceService.generateNewCaseInstanceId();
        if (StringUtils.isNotEmpty((CharSequence)caseServiceTask.getCaseInstanceIdVariableName()) && StringUtils.isNotEmpty((CharSequence)(idVariableName = (String)(expression = expressionManager.createExpression(caseServiceTask.getCaseInstanceIdVariableName())).getValue((VariableContainer)execution)))) {
            execution.setVariable(idVariableName, caseInstanceId);
        }
        if (processEngineConfiguration.isEnableEntityLinks()) {
            EntityLinkUtil.createEntityLinks(execution.getProcessInstanceId(), execution.getId(), caseServiceTask.getId(), caseInstanceId, "cmmn");
        }
        String caseDefinitionKey = this.getCaseDefinitionKey(caseServiceTask.getCaseDefinitionKey(), (VariableContainer)execution, expressionManager);
        String parentDeploymentId = null;
        if (caseServiceTask.isSameDeployment()) {
            parentDeploymentId = ProcessDefinitionUtil.getDefinitionDeploymentId(execution.getProcessDefinitionId(), processEngineConfiguration);
        }
        caseInstanceService.startCaseInstanceByKey(caseDefinitionKey, caseInstanceId, caseInstanceName, businessKey, execution.getId(), execution.getTenantId(), caseServiceTask.isFallbackToDefaultTenant(), parentDeploymentId, inParameters);
        executionEntity.setReferenceId(caseInstanceId);
        executionEntity.setReferenceType("bpmn-2.0-to-cmmn-1.1-child-case");
    }

    protected String getCaseDefinitionKey(String caseDefinitionKeyExpression, VariableContainer variableContainer, ExpressionManager expressionManager) {
        if (StringUtils.isNotEmpty((CharSequence)caseDefinitionKeyExpression)) {
            return (String)expressionManager.createExpression(caseDefinitionKeyExpression).getValue(variableContainer);
        }
        return caseDefinitionKeyExpression;
    }

    @Override
    public void completing(DelegateExecution execution, DelegateExecution subProcessInstance) throws Exception {
    }

    @Override
    public void completed(DelegateExecution execution) throws Exception {
    }

    public void triggerCaseTaskAndLeave(DelegateExecution execution, Map<String, Object> variables) {
        this.triggerCaseTask(execution, variables);
        this.leave(execution);
    }

    public void triggerCaseTask(DelegateExecution execution, Map<String, Object> variables) {
        execution.setVariables(variables);
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (executionEntity.isSuspended() || ProcessDefinitionUtil.isProcessDefinitionSuspended(execution.getProcessDefinitionId())) {
            throw new FlowableException("Cannot complete case task. Parent process instance " + String.valueOf(executionEntity) + " is suspended");
        }
        executionEntity.setReferenceId(null);
        executionEntity.setReferenceType(null);
    }
}

