/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cfg;

import java.util.function.Consumer;
import org.flowable.common.engine.api.Engine;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.engine.EngineLifecycleListener;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;

public class ProcessEnginePostEngineBuildConsumer
implements Consumer<ProcessEngine> {
    @Override
    public void accept(ProcessEngine processEngine) {
        Flowable5CompatibilityHandler flowable5CompatibilityHandler;
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)processEngine.getProcessEngineConfiguration();
        if (engineConfiguration.getEngineLifecycleListeners() != null) {
            for (EngineLifecycleListener engineLifecycleListener : engineConfiguration.getEngineLifecycleListeners()) {
                engineLifecycleListener.onEngineBuilt((Engine)processEngine);
            }
        }
        engineConfiguration.getEventDispatcher().dispatchEvent(FlowableEventBuilder.createGlobalEvent(FlowableEngineEventType.ENGINE_CREATED), engineConfiguration.getEngineCfgKey());
        if (engineConfiguration.isHandleProcessEngineExecutorsAfterEngineCreate()) {
            processEngine.startExecutors();
        }
        if (engineConfiguration.isFlowable5CompatibilityEnabled() && (flowable5CompatibilityHandler = engineConfiguration.getFlowable5CompatibilityHandler()) != null) {
            engineConfiguration.getCommandExecutor().execute(commandContext -> {
                flowable5CompatibilityHandler.getRawProcessEngine();
                return null;
            });
        }
        engineConfiguration.postProcessEngineInitialisation();
    }
}

