/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.impl.RuntimeServiceImpl;
import org.flowable.engine.runtime.ProcessInstanceStartEventSubscriptionModificationBuilder;

public class ProcessInstanceStartEventSubscriptionModificationBuilderImpl
implements ProcessInstanceStartEventSubscriptionModificationBuilder {
    protected final RuntimeServiceImpl runtimeService;
    protected String processDefinitionId;
    protected String newProcessDefinitionId;
    protected String tenantId;
    protected final Map<String, Object> correlationParameterValues = new HashMap<String, Object>();

    public ProcessInstanceStartEventSubscriptionModificationBuilderImpl(RuntimeServiceImpl runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionModificationBuilder processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionModificationBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionModificationBuilder addCorrelationParameterValue(String parameterName, Object parameterValue) {
        this.correlationParameterValues.put(parameterName, parameterValue);
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionModificationBuilder addCorrelationParameterValues(Map<String, Object> parameters) {
        this.correlationParameterValues.putAll(parameters);
        return this;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public boolean hasNewProcessDefinitionId() {
        return StringUtils.isNotBlank((CharSequence)this.newProcessDefinitionId);
    }

    public String getNewProcessDefinitionId() {
        return this.newProcessDefinitionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean hasCorrelationParameterValues() {
        return this.correlationParameterValues.size() > 0;
    }

    public Map<String, Object> getCorrelationParameterValues() {
        return this.correlationParameterValues;
    }

    @Override
    public void migrateToLatestProcessDefinition() {
        this.checkValidInformation();
        this.runtimeService.migrateProcessInstanceStartEventSubscriptionsToProcessDefinitionVersion(this);
    }

    @Override
    public void migrateToProcessDefinition(String processDefinitionId) {
        this.newProcessDefinitionId = processDefinitionId;
        this.checkValidInformation();
        this.runtimeService.migrateProcessInstanceStartEventSubscriptionsToProcessDefinitionVersion(this);
    }

    protected void checkValidInformation() {
        if (StringUtils.isEmpty((CharSequence)this.processDefinitionId)) {
            throw new FlowableIllegalArgumentException("The process definition must be provided using the exact id of the version the subscription was registered for.");
        }
    }
}

