/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import kafka.server.ControllerInformation;
import kafka.server.ControllerNodeProvider;
import kafka.server.KafkaConfig;
import kafka.server.NodeToControllerQueueItem;
import kafka.server.NodeToControllerRequestThread;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.immutable.Seq;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\f\u0018\u0001qA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\tu\u0001\u0011\t\u0011)A\u0005w!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002\u0003.\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011m\u0003!\u0011!Q\u0001\nqCQ\u0001\u0019\u0001\u0005\u0002\u0005DqA\u001b\u0001C\u0002\u0013%1\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001\u001c\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019A\b\u0001)A\u0005e\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bB\u0002@\u0001A\u0003%1\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\tI\u0001\u0001Q\u0001\n\u0005\r\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003+\u0001A\u0011AA\u0007\u0011!\t9\u0002\u0001C\u0001/\u0005\u0005\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003/\u0002A\u0011AA-\u0005\tru\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'/S7qY*\u0011\u0001$G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003i\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001;\u0015z\u0003C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0011a\u0017M\\4\u000b\u0003\t\nAA[1wC&\u0011Ae\b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0019jS\"A\u0014\u000b\u0005aA#B\u0001\u000e*\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\n\u00059:#A\b(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s!\t\u00014'D\u00012\u0015\t\u0011\u0014$A\u0003vi&d7/\u0003\u00025c\t9Aj\\4hS:<\u0017AF2p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:\u0011\u0005]BT\"A\f\n\u0005e:\"AF\"p]R\u0014x\u000e\u001c7fe:{G-\u001a)s_ZLG-\u001a:\u0002\tQLW.\u001a\t\u0003y\u0001k\u0011!\u0010\u0006\u0003eyR!a\u0010\u0015\u0002\r\r|W.\\8o\u0013\t\tUH\u0001\u0003US6,\u0017aB7fiJL7m\u001d\t\u0003\t\u001ak\u0011!\u0012\u0006\u0003\u0005zJ!aR#\u0003\u000f5+GO]5dg\u000611m\u001c8gS\u001e\u0004\"a\u000e&\n\u0005-;\"aC&bM.\f7i\u001c8gS\u001e\f1b\u00195b]:,GNT1nKB\u0011aj\u0016\b\u0003\u001fV\u0003\"\u0001U*\u000e\u0003ES!AU\u000e\u0002\rq\u0012xn\u001c;?\u0015\u0005!\u0016!B:dC2\f\u0017B\u0001,T\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001,\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Y\u001b\u0016\u0001\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y\u00039\u0011X\r\u001e:z)&lWm\\;u\u001bN\u0004\"!\u00180\u000e\u0003MK!aX*\u0003\t1{gnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\t\u001cG-\u001a4hQ&\u0004\"a\u000e\u0001\t\u000bUB\u0001\u0019\u0001\u001c\t\u000biB\u0001\u0019A\u001e\t\u000b\tC\u0001\u0019A\"\t\u000b!C\u0001\u0019A%\t\u000b1C\u0001\u0019A'\t\u000biC\u0001\u0019A'\t\u000bmC\u0001\u0019\u0001/\u0002\u00151|wmQ8oi\u0016DH/F\u0001m!\taT.\u0003\u0002o{\tQAj\\4D_:$X\r\u001f;\u0002\u00171|wmQ8oi\u0016DH\u000fI\u0001\u0016[\u0006tW/\u00197NKR\fG-\u0019;b+B$\u0017\r^3s+\u0005\u0011\bCA:w\u001b\u0005!(BA;)\u0003\u001d\u0019G.[3oiNL!a\u001e;\u0003+5\u000bg.^1m\u001b\u0016$\u0018\rZ1uCV\u0003H-\u0019;fe\u00061R.\u00198vC2lU\r^1eCR\fW\u000b\u001d3bi\u0016\u0014\b%A\u0006ba&4VM]:j_:\u001cX#A>\u0011\u0005Md\u0018BA?u\u0005-\t\u0005/\u001b,feNLwN\\:\u0002\u0019\u0005\u0004\u0018NV3sg&|gn\u001d\u0011\u0002\u001bI,\u0017/^3tiRC'/Z1e+\t\t\u0019\u0001E\u00028\u0003\u000bI1!a\u0002\u0018\u0005uqu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'OU3rk\u0016\u001cH\u000f\u00165sK\u0006$\u0017A\u0004:fcV,7\u000f\u001e+ie\u0016\fG\rI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0003\u001f\u00012!XA\t\u0013\r\t\u0019b\u0015\u0002\u0005+:LG/\u0001\u0005tQV$Hm\\<o\u0003AqWm\u001e*fcV,7\u000f\u001e+ie\u0016\fG-A\u0006tK:$'+Z9vKN$HCBA\b\u0003;\ti\u0005C\u0004\u0002 Q\u0001\r!!\t\u0002\u000fI,\u0017/^3tiB\"\u00111EA\u001e!\u0019\t)#!\r\u000289!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,y\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003_\tI#A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\u0011\t\u0019$!\u000e\u0003\u000f\t+\u0018\u000e\u001c3fe*!\u0011qFA\u0015!\u0011\tI$a\u000f\r\u0001\u0011a\u0011QHA\u000f\u0003\u0003\u0005\tQ!\u0001\u0002@\t\u0019q\fJ\u0019\u0012\t\u0005\u0005\u0013q\t\t\u0004;\u0006\r\u0013bAA#'\n9aj\u001c;iS:<\u0007\u0003BA\u0014\u0003\u0013JA!a\u0013\u0002*\ty\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0004\u0002PQ\u0001\r!!\u0015\u0002\u0011\r\fG\u000e\u001c2bG.\u00042AJA*\u0013\r\t)f\n\u0002#\u0007>tGO]8mY\u0016\u0014(+Z9vKN$8i\\7qY\u0016$\u0018n\u001c8IC:$G.\u001a:\u0002+\r|g\u000e\u001e:pY2,'/\u00119j-\u0016\u00148/[8ogR\u0011\u00111\f\t\u0007\u0003;\n\u0019'a\u001a\u000e\u0005\u0005}#bAA1C\u0005!Q\u000f^5m\u0013\u0011\t)'a\u0018\u0003\u0011=\u0003H/[8oC2\u00042a]A5\u0013\r\tY\u0007\u001e\u0002\u0010\u001d>$W-\u00119j-\u0016\u00148/[8og\u0002")
public class NodeToControllerChannelManagerImpl
implements NodeToControllerChannelManager,
Logging {
    private final ControllerNodeProvider controllerNodeProvider;
    private final Time time;
    private final Metrics metrics;
    private final KafkaConfig config;
    private final String channelName;
    private final String threadNamePrefix;
    private final long retryTimeoutMs;
    private final LogContext logContext;
    private final ManualMetadataUpdater manualMetadataUpdater;
    private final ApiVersions apiVersions;
    private final NodeToControllerRequestThread requestThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private ManualMetadataUpdater manualMetadataUpdater() {
        return this.manualMetadataUpdater;
    }

    private ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private NodeToControllerRequestThread requestThread() {
        return this.requestThread;
    }

    public void start() {
        this.requestThread().start();
    }

    public void shutdown() {
        this.requestThread().shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Node to controller channel manager for ").append($this.channelName).append(" shutdown").toString());
    }

    public NodeToControllerRequestThread newRequestThread() {
        String threadName = new StringBuilder(30).append(this.threadNamePrefix).append("to-controller-").append(this.channelName).append("-channel-manager").toString();
        ControllerInformation controllerInformation = this.controllerNodeProvider.getControllerInfo();
        return new NodeToControllerRequestThread((KafkaClient)this.buildNetworkClient$1(controllerInformation), controllerInformation.isZkController(), (Function1<ControllerInformation, KafkaClient>)(Function1 & Serializable)controllerInfo -> this.buildNetworkClient$1((ControllerInformation)controllerInfo), this.manualMetadataUpdater(), this.controllerNodeProvider, this.config, this.time, threadName, this.retryTimeoutMs);
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.requestThread().enqueue(new NodeToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    public Optional<NodeApiVersions> controllerApiVersions() {
        return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.requestThread().activeControllerAddress().flatMap((Function1 & Serializable)activeController -> Option$.MODULE$.apply((Object)this.apiVersions().get(activeController.idString())))));
    }

    private final NetworkClient buildNetworkClient$1(ControllerInformation controllerInfo) {
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerInfo.securityProtocol(), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerInfo.listenerName(), (String)controllerInfo.saslMechanism(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        Selector selector = new Selector(-1, -1L, this.metrics, this.time, this.channelName, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"BrokerId"), (Object)Integer.toString(this.config.brokerId()))}))).asJava(), false, channelBuilder, this.logContext());
        return new NetworkClient((Selectable)selector, (MetadataUpdater)this.manualMetadataUpdater(), Integer.toString(this.config.brokerId()), 1, 50L, 50L, -1, -1, (int)Math.min(Integer.MAX_VALUE, Math.min((long)this.config.controllerSocketTimeoutMs(), this.retryTimeoutMs)), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, true, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
    }

    public NodeToControllerChannelManagerImpl(ControllerNodeProvider controllerNodeProvider, Time time, Metrics metrics, KafkaConfig config, String channelName, String threadNamePrefix, long retryTimeoutMs) {
        this.controllerNodeProvider = controllerNodeProvider;
        this.time = time;
        this.metrics = metrics;
        this.config = config;
        this.channelName = channelName;
        this.threadNamePrefix = threadNamePrefix;
        this.retryTimeoutMs = retryTimeoutMs;
        this.logContext = new LogContext(new StringBuilder(43).append("[NodeToControllerChannelManager id=").append(config.nodeId()).append(" name=").append(channelName).append("] ").toString());
        this.manualMetadataUpdater = new ManualMetadataUpdater();
        this.apiVersions = new ApiVersions();
        this.requestThread = this.newRequestThread();
    }
}

