/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.DelegatedAuthenticationCredentialExtractor;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DefaultDelegatedAuthenticationCredentialExtractor
implements DelegatedAuthenticationCredentialExtractor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDelegatedAuthenticationCredentialExtractor.class);
    private final SessionStore sessionStore;

    public Optional<ClientCredential> extract(BaseClient client, RequestContext requestContext) {
        LOGGER.debug("Fetching credentials from delegated client [{}]", (Object)client);
        Optional<Credentials> credentials = this.getCredentialsFromDelegatedClient(requestContext, client);
        if (credentials.isPresent()) {
            Optional<ClientCredential> clientCredentialResult = this.buildClientCredential(client, requestContext, credentials.get());
            clientCredentialResult.ifPresent(clientCredential -> WebUtils.putCredential((RequestContext)requestContext, (Credential)clientCredential));
            return clientCredentialResult;
        }
        return Optional.empty();
    }

    protected Optional<ClientCredential> buildClientCredential(BaseClient client, RequestContext requestContext, Credentials credentials) {
        LOGGER.info("Credentials are successfully authenticated using the delegated client [{}]", (Object)client.getName());
        return Optional.of(new ClientCredential(credentials, client.getName()));
    }

    protected Optional<Credentials> getCredentialsFromDelegatedClient(RequestContext requestContext, BaseClient client) {
        return (Optional)FunctionUtils.doAndHandle(() -> {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            JEEContext webContext = new JEEContext(request, response);
            CallContext callContext = new CallContext((WebContext)webContext, this.sessionStore);
            return client.getCredentials(callContext).map(clientCredentials -> client.validateCredentials(callContext, clientCredentials)).filter(Optional::isPresent).map(Optional::get);
        }, e -> Optional.empty()).get();
    }

    @Generated
    public DefaultDelegatedAuthenticationCredentialExtractor(SessionStore sessionStore) {
        this.sessionStore = sessionStore;
    }
}

