/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidationResult;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.BaseSingleSignOnParticipationStrategy;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.support.WebUtils;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class SamlIdPSingleSignOnParticipationStrategy
extends BaseSingleSignOnParticipationStrategy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSingleSignOnParticipationStrategy.class);
    private final MultifactorAuthenticationContextValidator authenticationContextValidator;
    private final MultifactorAuthenticationTriggerSelectionStrategy multifactorTriggerSelectionStrategy;

    public SamlIdPSingleSignOnParticipationStrategy(ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, AuthenticationServiceSelectionPlan serviceSelectionStrategy, MultifactorAuthenticationContextValidator authenticationContextValidator, MultifactorAuthenticationTriggerSelectionStrategy multifactorTriggerSelectionStrategy) {
        super(servicesManager, ticketRegistrySupport, serviceSelectionStrategy);
        this.authenticationContextValidator = authenticationContextValidator;
        this.multifactorTriggerSelectionStrategy = multifactorTriggerSelectionStrategy;
    }

    public boolean isParticipating(SingleSignOnParticipationRequest ssoRequest) throws Throwable {
        Service service = (Service)ssoRequest.getAttributeValue(Service.class.getName(), Service.class);
        RegisteredService registeredService = (RegisteredService)ssoRequest.getAttributeValue(RegisteredService.class.getName(), RegisteredService.class);
        Authentication authentication = (Authentication)ssoRequest.getAttributeValue(Authentication.class.getName(), Authentication.class);
        HttpServletRequest request = ssoRequest.getHttpServletRequest().orElseGet(() -> WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)((RequestContext)ssoRequest.getRequestContext().orElseThrow())));
        HttpServletResponse response = ssoRequest.getHttpServletResponse().orElseGet(() -> WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)((RequestContext)ssoRequest.getRequestContext().orElseThrow())));
        AuthnRequest authnRequest = (AuthnRequest)ssoRequest.getAttributeValue(AuthnRequest.class.getName(), AuthnRequest.class);
        boolean initialResult = this.supports(ssoRequest) && Boolean.FALSE.equals(authnRequest.isForceAuthn());
        return (Boolean)FunctionUtils.doAndHandle(() -> this.resolveMultifactorAuthenticationTrigger(service, registeredService, authentication, request, response).map(requestedContext -> {
            LOGGER.trace("Validating authentication context for event [{}] and service [{}]", (Object)requestedContext.getId(), (Object)registeredService);
            MultifactorAuthenticationContextValidationResult result = this.authenticationContextValidator.validate(authentication, requestedContext.getId(), Optional.ofNullable(registeredService));
            Optional validatedProvider = result.getProvider();
            return initialResult && result.isSuccess() && validatedProvider.isPresent() && !registeredService.getMultifactorAuthenticationPolicy().isForceExecution();
        }).orElse(initialResult), throwable -> false).get();
    }

    protected Optional<MultifactorAuthenticationProvider> resolveMultifactorAuthenticationTrigger(Service service, RegisteredService registeredService, Authentication authentication, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        return this.multifactorTriggerSelectionStrategy.resolve(request, response, registeredService, authentication, service);
    }

    public boolean supports(SingleSignOnParticipationRequest ssoRequest) {
        return ssoRequest.containsAttribute(AuthnRequest.class.getName()) && ssoRequest.containsAttribute(Issuer.class.getName());
    }
}

