/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.camel.Exchange;
import org.apache.camel.converter.NIOConverter;

public final class NIOConverterOptimised {
    private NIOConverterOptimised() {
    }

    public static Object convertTo(Class<?> type, Exchange exchange, Object value) throws Exception {
        Class<?> fromType = value.getClass();
        if (type == String.class) {
            if (fromType == ByteBuffer.class) {
                return NIOConverter.toString((ByteBuffer)value, exchange);
            }
            return null;
        }
        if (type == byte[].class) {
            if (fromType == ByteBuffer.class) {
                return NIOConverter.toByteArray((ByteBuffer)value);
            }
            return null;
        }
        if (type == InputStream.class) {
            if (fromType == ByteBuffer.class) {
                return NIOConverter.toInputStream((ByteBuffer)value);
            }
            return null;
        }
        if (type == ByteBuffer.class) {
            if (fromType == byte[].class) {
                return NIOConverter.toByteBuffer((byte[])value);
            }
            if (fromType == File.class) {
                return NIOConverter.toByteBuffer((File)value);
            }
            if (fromType == String.class) {
                return NIOConverter.toByteBuffer((String)value, exchange);
            }
            if (fromType == Short.TYPE || fromType == Short.class) {
                return NIOConverter.toByteBuffer((Short)value);
            }
            if (fromType == Integer.TYPE || fromType == Integer.class) {
                return NIOConverter.toByteBuffer((Integer)value);
            }
            if (fromType == Long.TYPE || fromType == Long.class) {
                return NIOConverter.toByteBuffer((Long)value);
            }
            if (fromType == Float.TYPE || fromType == Float.class) {
                return NIOConverter.toByteBuffer((Float)value);
            }
            if (fromType == Double.TYPE || fromType == Double.class) {
                return NIOConverter.toByteBuffer((Double)value);
            }
            return null;
        }
        return null;
    }
}

