/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.undo;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.map.event.EntityEvent;
import org.apache.cayenne.modeler.event.EntityDisplayEvent;
import org.apache.cayenne.modeler.undo.CayenneUndoableEdit;

public class ChangePKGeneratorUndoableEdit
extends CayenneUndoableEdit {
    private DbEntity dbEntity;
    private PkGeneratorState oldState;
    private PkGeneratorState newState;

    public ChangePKGeneratorUndoableEdit(DbEntity dbEntity) {
        this.dbEntity = dbEntity;
    }

    public void captureOldState() {
        this.oldState = this.captureState();
    }

    public void captureNewState() {
        this.newState = this.captureState();
    }

    private PkGeneratorState captureState() {
        return new PkGeneratorState(this.dbEntity.getPrimaryKeyGenerator(), this.findGeneratedAttribute());
    }

    private DbAttribute findGeneratedAttribute() {
        for (DbAttribute attribute : this.dbEntity.getPrimaryKeys()) {
            if (!attribute.isGenerated()) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void redo() throws CannotRedoException {
        this.newState.apply();
        this.fireEvents();
    }

    @Override
    public void undo() throws CannotUndoException {
        this.oldState.apply();
        this.fireEvents();
    }

    private void fireEvents() {
        this.controller.fireDbEntityEvent(new EntityEvent((Object)this, this.dbEntity));
        this.controller.fireDbEntityDisplayEvent(new EntityDisplayEvent((Object)this, this.dbEntity));
    }

    public boolean hasRealChange() {
        return !this.oldState.equals(this.newState);
    }

    private class PkGeneratorState {
        private DbKeyGenerator generator;
        private DbAttribute generatedAttribute;

        private PkGeneratorState(DbKeyGenerator generator, DbAttribute generatedAttribute) {
            this.generator = generator;
            this.generatedAttribute = generatedAttribute;
        }

        private void resetState() {
            DbAttribute oldAttribute = ChangePKGeneratorUndoableEdit.this.findGeneratedAttribute();
            if (oldAttribute != null) {
                oldAttribute.setGenerated(false);
            }
            ChangePKGeneratorUndoableEdit.this.dbEntity.setPrimaryKeyGenerator(null);
        }

        private void apply() {
            this.resetState();
            if (this.generator != null) {
                ChangePKGeneratorUndoableEdit.this.dbEntity.setPrimaryKeyGenerator(this.generator);
            }
            if (this.generatedAttribute != null) {
                this.generatedAttribute.setGenerated(true);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PkGeneratorState that = (PkGeneratorState)o;
            if (this.generator != null ? !this.generator.equals(that.generator) : that.generator != null) {
                return false;
            }
            return this.generatedAttribute != null ? this.generatedAttribute.equals(that.generatedAttribute) : that.generatedAttribute == null;
        }

        public int hashCode() {
            int result = this.generator != null ? this.generator.hashCode() : 0;
            result = 31 * result + (this.generatedAttribute != null ? this.generatedAttribute.hashCode() : 0);
            return result;
        }
    }
}

