/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.binding.soap;

import jakarta.jws.soap.SOAPBinding;
import java.lang.reflect.Method;
import org.apache.cxf.binding.soap.SoapBindingConfiguration;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.model.OperationInfo;

public class JaxWsSoapBindingConfiguration
extends SoapBindingConfiguration {
    JaxWsServiceFactoryBean serviceFactory;

    public JaxWsSoapBindingConfiguration(JaxWsServiceFactoryBean sifb) {
        this.serviceFactory = sifb;
    }

    public void setJaxWsServiceFactoryBean(JaxWsServiceFactoryBean b) {
        this.serviceFactory = b;
    }

    public String getStyle(OperationInfo op) {
        Method m = (Method)op.getProperty("operation.method", Method.class);
        if (m != null) {
            return this.serviceFactory.isRPC(m) ? "rpc" : "document";
        }
        return this.getStyle();
    }

    public String getStyle() {
        SOAPBinding sb = this.getServiceClass().getAnnotation(SOAPBinding.class);
        if (sb != null) {
            if (sb.style() == SOAPBinding.Style.DOCUMENT) {
                return "document";
            }
            if (sb.style() == SOAPBinding.Style.RPC) {
                return "rpc";
            }
        }
        return super.getStyle();
    }

    Class<?> getServiceClass() {
        return this.getJaxWsServiceFactory().getJaxWsImplementorInfo().getEndpointClass();
    }

    private JaxWsServiceFactoryBean getJaxWsServiceFactory() {
        return this.serviceFactory;
    }

    public String getUse() {
        SOAPBinding sb = this.getServiceClass().getAnnotation(SOAPBinding.class);
        if (sb != null) {
            if (sb.use() == SOAPBinding.Use.LITERAL) {
                return "literal";
            }
            if (sb.use() == SOAPBinding.Use.ENCODED) {
                return "encoded";
            }
        }
        return super.getUse();
    }
}

