/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.TgtHllType;

final class PreambleUtil {
    static int PREAMBLE_INTS_BYTE = 0;
    static int SER_VER_BYTE = 1;
    static int FAMILY_BYTE = 2;
    static int LG_K_BYTE = 3;
    static int LG_ARR_BYTE = 4;
    static int FLAGS_BYTE = 5;
    static int LIST_COUNT_BYTE = 6;
    static int HLL_CUR_MIN_BYTE = 6;
    static int MODE_BYTE = 7;
    static int LIST_INT_ARR_START = 8;
    static int HASH_SET_COUNT_INT = 8;
    static int HASH_SET_INT_ARR_START = 12;
    static int HIP_ACCUM_DOUBLE = 8;
    static int KXQ0_DOUBLE = 16;
    static int KXQ1_DOUBLE = 24;
    static int CUR_MIN_COUNT_INT = 32;
    static int AUX_COUNT_INT = 36;
    static int HLL_BYTE_ARR_START = 40;
    static final int RESERVED_FLAG_MASK = 1;
    static final int READ_ONLY_FLAG_MASK = 2;
    static final int EMPTY_FLAG_MASK = 4;
    static final int COMPACT_FLAG_MASK = 8;
    static final int OUT_OF_ORDER_FLAG_MASK = 16;
    static final int REBUILD_CURMIN_NUM_KXQ_MASK = 32;
    static final int CUR_MODE_MASK = 3;
    static final int TGT_HLL_TYPE_MASK = 12;
    static final int SER_VER = 1;
    static final int FAMILY_ID = 7;
    static final int LIST_PREINTS = 2;
    static final int HASH_SET_PREINTS = 3;
    static final int HLL_PREINTS = 10;

    private PreambleUtil() {
    }

    static String toString(byte[] byteArr) {
        MemorySegment seg = MemorySegment.ofArray(byteArr);
        return PreambleUtil.toString(seg);
    }

    static String toString(MemorySegment seg) {
        byte hllCurMin;
        byte preInts = seg.get(ValueLayout.JAVA_BYTE, (long)PREAMBLE_INTS_BYTE);
        byte serVer = seg.get(ValueLayout.JAVA_BYTE, (long)SER_VER_BYTE);
        Family family = Family.idToFamily(seg.get(ValueLayout.JAVA_BYTE, (long)FAMILY_BYTE));
        byte lgK = seg.get(ValueLayout.JAVA_BYTE, (long)LG_K_BYTE);
        byte lgArr = seg.get(ValueLayout.JAVA_BYTE, (long)LG_ARR_BYTE);
        byte flags = seg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE);
        String flagsStr = Util.zeroPad(Integer.toBinaryString(flags), 8) + ", " + flags;
        boolean compact = (flags & 8) > 0;
        boolean oooFlag = (flags & 0x10) > 0;
        boolean readOnly = (flags & 2) > 0;
        boolean empty = (flags & 4) > 0;
        boolean rebuildKxQ = (flags & 0x20) > 0;
        byte listCount = hllCurMin = seg.get(ValueLayout.JAVA_BYTE, (long)HLL_CUR_MIN_BYTE);
        byte modeByte = seg.get(ValueLayout.JAVA_BYTE, (long)MODE_BYTE);
        CurMode curMode = CurMode.fromOrdinal(modeByte & 3);
        TgtHllType tgtHllType = TgtHllType.fromOrdinal(modeByte >>> 2 & 3);
        double hipAccum = 0.0;
        double kxq0 = 0.0;
        double kxq1 = 0.0;
        int hashSetCount = 0;
        int curMinCount = 0;
        int exceptionCount = 0;
        if (curMode == CurMode.SET) {
            hashSetCount = seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)HASH_SET_COUNT_INT);
        } else if (curMode == CurMode.HLL) {
            hipAccum = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)HIP_ACCUM_DOUBLE);
            kxq0 = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)KXQ0_DOUBLE);
            kxq1 = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)KXQ1_DOUBLE);
            curMinCount = seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)CUR_MIN_COUNT_INT);
            exceptionCount = seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)AUX_COUNT_INT);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(Util.LS);
        sb.append("### HLL SKETCH PREAMBLE:").append(Util.LS);
        sb.append("Byte 0: Preamble Ints         : ").append(preInts).append(Util.LS);
        sb.append("Byte 1: SerVer                : ").append(serVer).append(Util.LS);
        sb.append("Byte 2: Family                : ").append((Object)family).append(Util.LS);
        sb.append("Byte 3: lgK                   : ").append(lgK).append(Util.LS);
        if (curMode == CurMode.LIST) {
            sb.append("Byte 4: LgArr: List Arr       : ").append(lgArr).append(Util.LS);
        }
        if (curMode == CurMode.SET) {
            sb.append("Byte 4: LgArr: Hash Set Arr   : ").append(lgArr).append(Util.LS);
        }
        if (curMode == CurMode.HLL) {
            sb.append("Byte 4: LgArr or Aux LgArr    : ").append(lgArr).append(Util.LS);
        }
        sb.append("Byte 5: Flags:                : ").append(flagsStr).append(Util.LS);
        sb.append("  READ_ONLY                   : ").append(readOnly).append(Util.LS);
        sb.append("  EMPTY                       : ").append(empty).append(Util.LS);
        sb.append("  COMPACT                     : ").append(compact).append(Util.LS);
        sb.append("  OUT_OF_ORDER                : ").append(oooFlag).append(Util.LS);
        sb.append("  REBUILD_KXQ                 : ").append(rebuildKxQ).append(Util.LS);
        if (curMode == CurMode.LIST) {
            sb.append("Byte 6: List Count/CurMin     : ").append(listCount).append(Util.LS);
        }
        if (curMode == CurMode.SET) {
            sb.append("Byte 6: (not used)            : ").append(Util.LS);
        }
        if (curMode == CurMode.HLL) {
            sb.append("Byte 6: Cur Min               : ").append(hllCurMin).append(Util.LS);
        }
        String modes = curMode.toString() + ", " + tgtHllType.toString();
        sb.append("Byte 7: Mode                  : ").append(modes).append(Util.LS);
        if (curMode == CurMode.SET) {
            sb.append("Hash Set Count                : ").append(hashSetCount).append(Util.LS);
        }
        if (curMode == CurMode.HLL) {
            sb.append("HIP Accum                     : ").append(hipAccum).append(Util.LS);
            sb.append("KxQ0                          : ").append(kxq0).append(Util.LS);
            sb.append("KxQ1                          : ").append(kxq1).append(Util.LS);
            sb.append("Num At Cur Min                : ").append(curMinCount).append(Util.LS);
            sb.append("Aux Count                     : ").append(exceptionCount).append(Util.LS);
        }
        sb.append("### END HLL SKETCH PREAMBLE").append(Util.LS);
        return sb.toString();
    }

    static int extractPreInts(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)PREAMBLE_INTS_BYTE) & 0x3F;
    }

    static void insertPreInts(MemorySegment wseg, int preInts) {
        wseg.set(ValueLayout.JAVA_BYTE, (long)PREAMBLE_INTS_BYTE, (byte)(preInts & 0x3F));
    }

    static int extractSerVer(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)SER_VER_BYTE) & 0xFF;
    }

    static void insertSerVer(MemorySegment wseg) {
        wseg.set(ValueLayout.JAVA_BYTE, (long)SER_VER_BYTE, (byte)1);
    }

    static int extractFamilyId(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)FAMILY_BYTE) & 0xFF;
    }

    static void insertFamilyId(MemorySegment wseg) {
        wseg.set(ValueLayout.JAVA_BYTE, (long)FAMILY_BYTE, (byte)7);
    }

    static int extractLgK(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)LG_K_BYTE) & 0xFF;
    }

    static void insertLgK(MemorySegment wseg, int lgK) {
        wseg.set(ValueLayout.JAVA_BYTE, (long)LG_K_BYTE, (byte)lgK);
    }

    static int extractLgArr(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)LG_ARR_BYTE) & 0xFF;
    }

    static void insertLgArr(MemorySegment wseg, int lgArr) {
        wseg.set(ValueLayout.JAVA_BYTE, (long)LG_ARR_BYTE, (byte)lgArr);
    }

    static int extractListCount(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)LIST_COUNT_BYTE) & 0xFF;
    }

    static void insertListCount(MemorySegment wseg, int listCnt) {
        wseg.set(ValueLayout.JAVA_BYTE, (long)LIST_COUNT_BYTE, (byte)listCnt);
    }

    static int extractCurMin(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)HLL_CUR_MIN_BYTE) & 0xFF;
    }

    static void insertCurMin(MemorySegment wseg, int curMin) {
        wseg.set(ValueLayout.JAVA_BYTE, (long)HLL_CUR_MIN_BYTE, (byte)curMin);
    }

    static double extractHipAccum(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)HIP_ACCUM_DOUBLE);
    }

    static void insertHipAccum(MemorySegment wseg, double hipAccum) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)HIP_ACCUM_DOUBLE, hipAccum);
    }

    static double extractKxQ0(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)KXQ0_DOUBLE);
    }

    static void insertKxQ0(MemorySegment wseg, double kxq0) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)KXQ0_DOUBLE, kxq0);
    }

    static double extractKxQ1(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)KXQ1_DOUBLE);
    }

    static void insertKxQ1(MemorySegment wseg, double kxq1) {
        wseg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)KXQ1_DOUBLE, kxq1);
    }

    static int extractHashSetCount(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)HASH_SET_COUNT_INT);
    }

    static void insertHashSetCount(MemorySegment wseg, int hashSetCnt) {
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)HASH_SET_COUNT_INT, hashSetCnt);
    }

    static int extractNumAtCurMin(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)CUR_MIN_COUNT_INT);
    }

    static void insertNumAtCurMin(MemorySegment wseg, int numAtCurMin) {
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)CUR_MIN_COUNT_INT, numAtCurMin);
    }

    static int extractAuxCount(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)AUX_COUNT_INT);
    }

    static void insertAuxCount(MemorySegment wseg, int auxCount) {
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, (long)AUX_COUNT_INT, auxCount);
    }

    static void insertCurMode(MemorySegment wseg, CurMode curMode) {
        int curModeId = curMode.ordinal();
        int mode = wseg.get(ValueLayout.JAVA_BYTE, (long)MODE_BYTE) & 0xFFFFFFFC;
        wseg.set(ValueLayout.JAVA_BYTE, (long)MODE_BYTE, (byte)(mode |= curModeId & 3));
    }

    static CurMode extractCurMode(MemorySegment seg) {
        int curModeId = seg.get(ValueLayout.JAVA_BYTE, (long)MODE_BYTE) & 3;
        return CurMode.fromOrdinal(curModeId);
    }

    static void insertTgtHllType(MemorySegment wseg, TgtHllType tgtHllType) {
        int typeId = tgtHllType.ordinal();
        int mode = wseg.get(ValueLayout.JAVA_BYTE, (long)MODE_BYTE) & 0xFFFFFFF3;
        wseg.set(ValueLayout.JAVA_BYTE, (long)MODE_BYTE, (byte)(mode |= typeId << 2 & 0xC));
    }

    static TgtHllType extractTgtHllType(MemorySegment seg) {
        int typeId = seg.get(ValueLayout.JAVA_BYTE, (long)MODE_BYTE) & 0xC;
        return TgtHllType.fromOrdinal(typeId >>> 2);
    }

    static void insertModes(MemorySegment wseg, TgtHllType tgtHllType, CurMode curMode) {
        int curModeId = curMode.ordinal() & 3;
        int typeId = (tgtHllType.ordinal() & 3) << 2;
        int mode = typeId | curModeId;
        wseg.set(ValueLayout.JAVA_BYTE, (long)MODE_BYTE, (byte)mode);
    }

    static void insertEmptyFlag(MemorySegment wseg, boolean empty) {
        int flags = wseg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE);
        flags = empty ? (flags |= 4) : (flags &= 0xFFFFFFFB);
        wseg.set(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE, (byte)flags);
    }

    static boolean extractEmptyFlag(MemorySegment seg) {
        byte flags = seg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE);
        return (flags & 4) > 0;
    }

    static void insertCompactFlag(MemorySegment wseg, boolean compact) {
        int flags = wseg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE);
        flags = compact ? (flags |= 8) : (flags &= 0xFFFFFFF7);
        wseg.set(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE, (byte)flags);
    }

    static boolean extractCompactFlag(MemorySegment seg) {
        byte flags = seg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE);
        return (flags & 8) > 0;
    }

    static void insertOooFlag(MemorySegment wseg, boolean oooFlag) {
        int flags = wseg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE);
        flags = oooFlag ? (flags |= 0x10) : (flags &= 0xFFFFFFEF);
        wseg.set(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE, (byte)flags);
    }

    static boolean extractOooFlag(MemorySegment seg) {
        byte flags = seg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE);
        return (flags & 0x10) > 0;
    }

    static void insertRebuildCurMinNumKxQFlag(MemorySegment wseg, boolean rebuild) {
        int flags = wseg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE);
        flags = rebuild ? (flags |= 0x20) : (flags &= 0xFFFFFFDF);
        wseg.set(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE, (byte)flags);
    }

    static boolean extractRebuildCurMinNumKxQFlag(MemorySegment seg) {
        byte flags = seg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE);
        return (flags & 0x20) > 0;
    }

    static void insertFlags(MemorySegment wseg, int flags) {
        wseg.set(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE, (byte)flags);
    }

    static int extractFlags(MemorySegment seg) {
        return seg.get(ValueLayout.JAVA_BYTE, (long)FLAGS_BYTE) & 0xFF;
    }

    static int extractInt(MemorySegment seg, long byteOffset) {
        return seg.get(ValueLayout.JAVA_INT_UNALIGNED, byteOffset);
    }

    static void insertInt(MemorySegment wseg, long byteOffset, int value) {
        wseg.set(ValueLayout.JAVA_INT_UNALIGNED, byteOffset, value);
    }

    static int computeLgArr(MemorySegment seg, int count, int lgConfigK) {
        CurMode curMode = PreambleUtil.extractCurMode(seg);
        if (curMode == CurMode.LIST) {
            return 3;
        }
        int ceilPwr2 = Util.ceilingPowerOf2(count);
        if (4 * count > 3 * ceilPwr2) {
            ceilPwr2 <<= 1;
        }
        if (curMode == CurMode.SET) {
            return Math.max(5, Util.exactLog2OfLong(ceilPwr2));
        }
        return Math.max(HllUtil.LG_AUX_ARR_INTS[lgConfigK], Util.exactLog2OfLong(ceilPwr2));
    }
}

