/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantilescommon.DoublesSortedView;
import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.apache.datasketches.quantilescommon.IncludeMinMax;
import org.apache.datasketches.quantilescommon.InequalitySearch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesDoublesAPI;
import org.apache.datasketches.quantilescommon.QuantilesUtil;

public final class DoublesSketchSortedView
implements DoublesSortedView {
    private final double[] quantiles;
    private final long[] cumWeights;
    private final long totalN;

    public DoublesSketchSortedView(double[] quantiles, long[] cumWeights, QuantilesDoublesAPI sk) {
        IncludeMinMax.DoublesPair dPair = IncludeMinMax.includeDoublesMinMax(quantiles, cumWeights, sk.getMaxItem(), sk.getMinItem());
        this.quantiles = dPair.quantiles;
        this.cumWeights = dPair.cumWeights;
        this.totalN = sk.getN();
    }

    DoublesSketchSortedView(double[] quantiles, long[] cumWeights, long totalN, double maxItem, double minItem) {
        IncludeMinMax.DoublesPair dPair = IncludeMinMax.includeDoublesMinMax(quantiles, cumWeights, maxItem, minItem);
        this.quantiles = dPair.quantiles;
        this.cumWeights = dPair.cumWeights;
        this.totalN = totalN;
    }

    @Override
    public long[] getCumulativeWeights() {
        return (long[])this.cumWeights.clone();
    }

    @Override
    public double getMaxItem() {
        int top = this.quantiles.length - 1;
        return this.quantiles[top];
    }

    @Override
    public double getMinItem() {
        return this.quantiles[0];
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    @Override
    public int getNumRetained() {
        return this.quantiles.length;
    }

    @Override
    public double getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        QuantilesUtil.checkNormalizedRankBounds(rank);
        int len = this.cumWeights.length;
        double naturalRank = QuantilesUtil.getNaturalRank(rank, this.totalN, searchCrit);
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.GE : InequalitySearch.GT;
        int index = InequalitySearch.find(this.cumWeights, 0, len - 1, naturalRank, crit);
        if (index == -1) {
            return this.quantiles[len - 1];
        }
        return this.quantiles[index];
    }

    @Override
    public double[] getQuantiles() {
        return (double[])this.quantiles.clone();
    }

    @Override
    public double getRank(double quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        int len = this.quantiles.length;
        InequalitySearch crit = searchCrit == QuantileSearchCriteria.INCLUSIVE ? InequalitySearch.LE : InequalitySearch.LT;
        int index = InequalitySearch.find(this.quantiles, 0, len - 1, quantile, crit);
        if (index == -1) {
            return 0.0;
        }
        return (double)this.cumWeights[index] / (double)this.totalN;
    }

    @Override
    public boolean isEmpty() {
        return this.totalN == 0L;
    }

    @Override
    public DoublesSortedViewIterator iterator() {
        return new DoublesSortedViewIterator(this.quantiles, this.cumWeights);
    }
}

