/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.plan.serializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.agents.api.resource.ResourceType;
import org.apache.flink.agents.plan.AgentConfiguration;
import org.apache.flink.agents.plan.AgentPlan;
import org.apache.flink.agents.plan.actions.Action;
import org.apache.flink.agents.plan.resourceprovider.ResourceProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JacksonException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;

public class AgentPlanJsonDeserializer
extends StdDeserializer<AgentPlan> {
    public AgentPlanJsonDeserializer() {
        super(AgentPlan.class);
    }

    @Override
    public AgentPlan deserialize(JsonParser parser, DeserializationContext ctx) throws IOException, JacksonException {
        JsonNode configDataNode;
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        JsonNode actionsNode = node.get("actions");
        JavaType actionType = ctx.constructType(Action.class);
        JsonDeserializer<Object> actionDeserializer = ctx.findContextualValueDeserializer(actionType, null);
        HashMap<String, Action> actions = new HashMap<String, Action>();
        if (actionsNode != null && actionsNode.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> iterator = actionsNode.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                String actionName = entry.getKey();
                JsonNode actionNode = entry.getValue();
                JsonParser actionParser = codec.treeAsTokens(actionNode);
                Action action = (Action)actionDeserializer.deserialize(actionParser, ctx);
                actions.put(actionName, action);
            }
        }
        JsonNode actionsByEventNode = node.get("actions_by_event");
        HashMap<String, List<Action>> actionsByEvent = new HashMap<String, List<Action>>();
        if (actionsByEventNode != null && actionsByEventNode.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> iterator = actionsByEventNode.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                String eventClassName = entry.getKey();
                JsonNode actionsArrayNode = entry.getValue();
                ArrayList<Action> actionsTriggeredByEvent = new ArrayList<Action>();
                for (JsonNode actionNameNode : actionsArrayNode) {
                    String actionName = actionNameNode.asText();
                    Action action = (Action)actions.get(actionName);
                    if (action == null) {
                        throw new IllegalStateException("Unknown action name: " + actionName);
                    }
                    actionsTriggeredByEvent.add(action);
                }
                actionsByEvent.put(eventClassName, actionsTriggeredByEvent);
            }
        }
        JsonNode resourceProvidersNode = node.get("resource_providers");
        JavaType resourceProviderType = ctx.constructType(ResourceProvider.class);
        JsonDeserializer<Object> resourceProviderDeserializer = ctx.findContextualValueDeserializer(resourceProviderType, null);
        HashMap<ResourceType, Map<String, ResourceProvider>> resourceProviders = new HashMap<ResourceType, Map<String, ResourceProvider>>();
        if (resourceProvidersNode != null && resourceProvidersNode.isObject()) {
            Iterator<Map.Entry<String, JsonNode>> iterator = resourceProvidersNode.fields();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonNode> entry = iterator.next();
                String resourceType = entry.getKey();
                JsonNode providers = entry.getValue();
                Iterator<Map.Entry<String, JsonNode>> providerIterator = providers.fields();
                HashMap<String, ResourceProvider> nameToProvider = new HashMap<String, ResourceProvider>();
                while (providerIterator.hasNext()) {
                    Map.Entry<String, JsonNode> providerEntry = providerIterator.next();
                    String name = providerEntry.getKey();
                    JsonNode provider = providerEntry.getValue();
                    JsonParser resourceProviderParser = codec.treeAsTokens(provider);
                    ResourceProvider resourceProvider = (ResourceProvider)resourceProviderDeserializer.deserialize(resourceProviderParser, ctx);
                    nameToProvider.put(name, resourceProvider);
                }
                resourceProviders.put(ResourceType.fromValue(resourceType), nameToProvider);
            }
        }
        JsonNode configNode = node.get("config");
        Map<String, Object> configData = new HashMap<String, Object>();
        if (configNode != null && configNode.isObject() && (configDataNode = configNode.get("conf_data")) != null && configDataNode.isObject()) {
            ObjectMapper mapper = new ObjectMapper();
            configData = mapper.convertValue((Object)configDataNode, Map.class);
        }
        AgentConfiguration config = new AgentConfiguration(configData);
        return new AgentPlan(actions, actionsByEvent, resourceProviders, config);
    }
}

