/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.entity.EntityNameLookupRecord;
import org.apache.polaris.core.entity.LocationBasedEntity;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisChangeTrackingVersions;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisEntityId;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PolarisEvent;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.entity.PolarisPrincipalSecrets;
import org.apache.polaris.core.persistence.BaseMetaStoreManager;
import org.apache.polaris.core.persistence.BasePersistence;
import org.apache.polaris.core.persistence.EntityAlreadyExistsException;
import org.apache.polaris.core.persistence.IntegrationPersistence;
import org.apache.polaris.core.persistence.PolicyMappingAlreadyExistsException;
import org.apache.polaris.core.persistence.PrincipalSecretsGenerator;
import org.apache.polaris.core.persistence.RetryOnConcurrencyException;
import org.apache.polaris.core.persistence.pagination.EntityIdToken;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;
import org.apache.polaris.core.policy.PolarisPolicyMappingRecord;
import org.apache.polaris.core.policy.PolicyEntity;
import org.apache.polaris.core.policy.PolicyType;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.apache.polaris.core.storage.PolarisStorageIntegrationProvider;
import org.apache.polaris.core.storage.StorageLocation;
import org.apache.polaris.persistence.relational.jdbc.DatasourceOperations;
import org.apache.polaris.persistence.relational.jdbc.IdGenerator;
import org.apache.polaris.persistence.relational.jdbc.QueryGenerator;
import org.apache.polaris.persistence.relational.jdbc.models.EntityNameLookupRecordConverter;
import org.apache.polaris.persistence.relational.jdbc.models.ModelEntity;
import org.apache.polaris.persistence.relational.jdbc.models.ModelEvent;
import org.apache.polaris.persistence.relational.jdbc.models.ModelGrantRecord;
import org.apache.polaris.persistence.relational.jdbc.models.ModelPolicyMappingRecord;
import org.apache.polaris.persistence.relational.jdbc.models.ModelPrincipalAuthenticationData;
import org.apache.polaris.persistence.relational.jdbc.models.SchemaVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcBasePersistenceImpl
implements BasePersistence,
IntegrationPersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcBasePersistenceImpl.class);
    private final PolarisDiagnostics diagnostics;
    private final DatasourceOperations datasourceOperations;
    private final PrincipalSecretsGenerator secretsGenerator;
    private final PolarisStorageIntegrationProvider storageIntegrationProvider;
    private final String realmId;
    private final int schemaVersion;
    private static final int MAX_LOCATION_COMPONENTS = 40;

    public JdbcBasePersistenceImpl(PolarisDiagnostics diagnostics, DatasourceOperations databaseOperations, PrincipalSecretsGenerator secretsGenerator, PolarisStorageIntegrationProvider storageIntegrationProvider, String realmId, int schemaVersion) {
        this.diagnostics = diagnostics;
        this.datasourceOperations = databaseOperations;
        this.secretsGenerator = secretsGenerator;
        this.storageIntegrationProvider = storageIntegrationProvider;
        this.realmId = realmId;
        this.schemaVersion = schemaVersion;
    }

    public long generateNewId(@Nonnull PolarisCallContext callCtx) {
        return IdGenerator.getIdGenerator().nextId();
    }

    public void writeEntity(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, boolean nameOrParentChanged, PolarisBaseEntity originalEntity) {
        try {
            this.persistEntity(callCtx, entity, originalEntity, null, (connection, preparedQuery) -> this.datasourceOperations.executeUpdate(preparedQuery));
        }
        catch (SQLException e) {
            throw new RuntimeException("Error persisting entity", e);
        }
    }

    public void writeEntities(@Nonnull PolarisCallContext callCtx, @Nonnull List<PolarisBaseEntity> entities, List<PolarisBaseEntity> originalEntities) {
        try {
            this.datasourceOperations.runWithinTransaction(connection -> {
                for (int i = 0; i < entities.size(); ++i) {
                    PolarisBaseEntity entity = (PolarisBaseEntity)entities.get(i);
                    PolarisBaseEntity originalEntity = originalEntities != null ? (PolarisBaseEntity)originalEntities.get(i) : null;
                    PolarisBaseEntity entityFound = this.lookupEntity(callCtx, entity.getCatalogId(), entity.getId(), entity.getTypeCode());
                    if (entityFound != null && originalEntity == null) continue;
                    this.persistEntity(callCtx, entity, originalEntity, connection, this.datasourceOperations::execute);
                }
                return true;
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Error executing the transaction for writing entities due to %s", e.getMessage()), e);
        }
    }

    private void persistEntity(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, PolarisBaseEntity originalEntity, Connection connection, QueryAction queryAction) throws SQLException {
        ModelEntity modelEntity = ModelEntity.fromEntity(entity, this.schemaVersion);
        if (originalEntity == null) {
            try {
                List<Object> values = modelEntity.toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList();
                queryAction.apply(connection, QueryGenerator.generateInsertQuery(ModelEntity.getAllColumnNames(this.schemaVersion), "ENTITIES", values, this.realmId));
            }
            catch (SQLException e) {
                if (this.datasourceOperations.isConstraintViolation(e)) {
                    PolarisBaseEntity existingEntity = this.lookupEntityByName(callCtx, entity.getCatalogId(), entity.getParentId(), entity.getTypeCode(), entity.getName());
                    throw new EntityAlreadyExistsException(existingEntity != null ? existingEntity : entity, (Throwable)e);
                }
                throw new RuntimeException(String.format("Failed to write entity due to %s", e.getMessage()), e);
            }
        }
        Map<String, Object> params = Map.of("id", originalEntity.getId(), "catalog_id", originalEntity.getCatalogId(), "entity_version", originalEntity.getEntityVersion(), "realm_id", this.realmId);
        try {
            List<Object> values = modelEntity.toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList();
            int rowsUpdated = queryAction.apply(connection, QueryGenerator.generateUpdateQuery(ModelEntity.getAllColumnNames(this.schemaVersion), "ENTITIES", values, params));
            if (rowsUpdated == 0) {
                throw new RetryOnConcurrencyException("Entity '%s' id '%s' concurrently modified; expected version %s", new Object[]{originalEntity.getName(), originalEntity.getId(), originalEntity.getEntityVersion()});
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to write entity due to %s", e.getMessage()), e);
        }
    }

    public void writeToGrantRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisGrantRecord grantRec) {
        ModelGrantRecord modelGrantRecord = ModelGrantRecord.fromGrantRecord(grantRec);
        try {
            List<Object> values = modelGrantRecord.toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList();
            this.datasourceOperations.executeUpdate(QueryGenerator.generateInsertQuery(ModelGrantRecord.ALL_COLUMNS, "GRANT_RECORDS", values, this.realmId));
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to write to grant records due to %s", e.getMessage()), e);
        }
    }

    public void writeEvents(@Nonnull List<PolarisEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        try {
            QueryGenerator.PreparedQuery firstPreparedQuery = QueryGenerator.generateInsertQuery(ModelEvent.ALL_COLUMNS, "EVENTS", ModelEvent.fromEvent(events.getFirst()).toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList(), this.realmId);
            String expectedSql = firstPreparedQuery.sql();
            ArrayList<List<Object>> parametersList = new ArrayList<List<Object>>();
            parametersList.add(firstPreparedQuery.parameters());
            for (int i = 1; i < events.size(); ++i) {
                PolarisEvent event = events.get(i);
                QueryGenerator.PreparedQuery pq = QueryGenerator.generateInsertQuery(ModelEvent.ALL_COLUMNS, "EVENTS", ModelEvent.fromEvent(event).toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList(), this.realmId);
                if (!expectedSql.equals(pq.sql())) {
                    throw new RuntimeException("All events did not generate the same SQL");
                }
                parametersList.add(pq.parameters());
            }
            int totalUpdated = this.datasourceOperations.executeBatchUpdate(new QueryGenerator.PreparedBatchQuery(expectedSql, parametersList));
            if (totalUpdated == 0) {
                throw new SQLException("No events were inserted.");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to write events due to %s", e.getMessage()), e);
        }
    }

    public void deleteEntity(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity) {
        ModelEntity modelEntity = ModelEntity.fromEntity(entity, this.schemaVersion);
        Map<String, Object> params = Map.of("id", modelEntity.getId(), "catalog_id", modelEntity.getCatalogId(), "realm_id", this.realmId);
        try {
            this.datasourceOperations.executeUpdate(QueryGenerator.generateDeleteQuery(ModelEntity.getAllColumnNames(this.schemaVersion), "ENTITIES", params));
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to delete entity due to %s", e.getMessage()), e);
        }
    }

    public void deleteFromGrantRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisGrantRecord grantRec) {
        ModelGrantRecord modelGrantRecord = ModelGrantRecord.fromGrantRecord(grantRec);
        try {
            Map<String, Object> whereClause = modelGrantRecord.toMap(this.datasourceOperations.getDatabaseType());
            whereClause.put("realm_id", this.realmId);
            this.datasourceOperations.executeUpdate(QueryGenerator.generateDeleteQuery(ModelGrantRecord.ALL_COLUMNS, "GRANT_RECORDS", whereClause));
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to delete from grant records due to %s", e.getMessage()), e);
        }
    }

    public void deleteAllEntityGrantRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisEntityCore entity, @Nonnull List<PolarisGrantRecord> grantsOnGrantee, @Nonnull List<PolarisGrantRecord> grantsOnSecurable) {
        try {
            this.datasourceOperations.executeUpdate(QueryGenerator.generateDeleteQueryForEntityGrantRecords(entity, this.realmId));
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to delete grant records due to %s", e.getMessage()), e);
        }
    }

    public void deleteAll(@Nonnull PolarisCallContext callCtx) {
        try {
            Map<String, String> params = Map.of("realm_id", this.realmId);
            this.datasourceOperations.runWithinTransaction(connection -> {
                this.datasourceOperations.execute(connection, QueryGenerator.generateDeleteQuery(ModelEntity.getAllColumnNames(this.schemaVersion), "ENTITIES", params));
                this.datasourceOperations.execute(connection, QueryGenerator.generateDeleteQuery(ModelGrantRecord.ALL_COLUMNS, "GRANT_RECORDS", params));
                this.datasourceOperations.execute(connection, QueryGenerator.generateDeleteQuery(ModelPrincipalAuthenticationData.ALL_COLUMNS, "PRINCIPAL_AUTHENTICATION_DATA", params));
                this.datasourceOperations.execute(connection, QueryGenerator.generateDeleteQuery(ModelPolicyMappingRecord.ALL_COLUMNS, "POLICY_MAPPING_RECORD", params));
                return true;
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to delete all due to %s", e.getMessage()), e);
        }
    }

    public PolarisBaseEntity lookupEntity(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, int typeCode) {
        Map<String, Object> params = Map.of("catalog_id", catalogId, "id", entityId, "type_code", typeCode, "realm_id", this.realmId);
        return this.getPolarisBaseEntity(QueryGenerator.generateSelectQuery(ModelEntity.getAllColumnNames(this.schemaVersion), "ENTITIES", params));
    }

    public PolarisBaseEntity lookupEntityByName(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, int typeCode, @Nonnull String name) {
        Map<String, Object> params = Map.of("catalog_id", catalogId, "parent_id", parentId, "type_code", typeCode, "name", name, "realm_id", this.realmId);
        return this.getPolarisBaseEntity(QueryGenerator.generateSelectQuery(ModelEntity.getAllColumnNames(this.schemaVersion), "ENTITIES", params));
    }

    @Nullable
    private PolarisBaseEntity getPolarisBaseEntity(QueryGenerator.PreparedQuery query) {
        try {
            List<PolarisBaseEntity> results = this.datasourceOperations.executeSelect(query, new ModelEntity(this.schemaVersion));
            if (results.isEmpty()) {
                return null;
            }
            if (results.size() > 1) {
                throw new IllegalStateException(String.format("More than one(%s) entities were found for a given type code : %s", results.size(), results.getFirst().getTypeCode()));
            }
            return results.getFirst();
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to retrieve polaris entity due to %s", e.getMessage()), e);
        }
    }

    @Nonnull
    public List<PolarisBaseEntity> lookupEntities(@Nonnull PolarisCallContext callCtx, List<PolarisEntityId> entityIds) {
        if (entityIds == null || entityIds.isEmpty()) {
            return new ArrayList<PolarisBaseEntity>();
        }
        QueryGenerator.PreparedQuery query = QueryGenerator.generateSelectQueryWithEntityIds(this.realmId, this.schemaVersion, entityIds);
        try {
            Map idMap = this.datasourceOperations.executeSelect(query, new ModelEntity(this.schemaVersion)).stream().collect(Collectors.toMap(e -> new PolarisEntityId(e.getCatalogId(), e.getId()), Function.identity()));
            return entityIds.stream().map(idMap::get).collect(Collectors.toList());
        }
        catch (SQLException e2) {
            throw new RuntimeException(String.format("Failed to retrieve polaris entities due to %s", e2.getMessage()), e2);
        }
    }

    @Nonnull
    public List<PolarisChangeTrackingVersions> lookupEntityVersions(@Nonnull PolarisCallContext callCtx, List<PolarisEntityId> entityIds) {
        Map<PolarisEntityId, ModelEntity> idToEntityMap = this.lookupEntities(callCtx, entityIds).stream().filter(Objects::nonNull).collect(Collectors.toMap(entry -> new PolarisEntityId(entry.getCatalogId(), entry.getId()), entry -> ModelEntity.fromEntity(entry, this.schemaVersion)));
        return entityIds.stream().map(entityId -> {
            ModelEntity entity = idToEntityMap.getOrDefault(entityId, null);
            return entity == null ? null : new PolarisChangeTrackingVersions(entity.getEntityVersion(), entity.getGrantRecordsVersion());
        }).collect(Collectors.toList());
    }

    private QueryGenerator.PreparedQuery buildEntityQuery(long catalogId, long parentId, PolarisEntityType entityType, PolarisEntitySubType entitySubType, PageToken pageToken, List<String> queryProjections) {
        Map<String, Object> whereGreater;
        Map<String, Object> whereEquals = Map.of("catalog_id", catalogId, "parent_id", parentId, "type_code", entityType.getCode(), "realm_id", this.realmId);
        if (entitySubType != PolarisEntitySubType.ANY_SUBTYPE) {
            HashMap<String, String> updatedWhereEquals = new HashMap<String, String>(whereEquals);
            updatedWhereEquals.put("sub_type_code", (String)((Object)Integer.valueOf(entitySubType.getCode())));
            whereEquals = updatedWhereEquals;
        }
        String orderByColumnName = null;
        if (pageToken.paginationRequested()) {
            orderByColumnName = "id";
            whereGreater = pageToken.valueAs(EntityIdToken.class).map(entityIdToken -> Map.of("id", entityIdToken.entityId())).orElse(Map.of());
        } else {
            whereGreater = Map.of();
        }
        return QueryGenerator.generateSelectQuery(queryProjections, "ENTITIES", whereEquals, whereGreater, orderByColumnName);
    }

    @Nonnull
    public Page<EntityNameLookupRecord> listEntities(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull PageToken pageToken) {
        try {
            QueryGenerator.PreparedQuery query = this.buildEntityQuery(catalogId, parentId, entityType, entitySubType, pageToken, ModelEntity.ENTITY_LOOKUP_COLUMNS);
            AtomicReference results = new AtomicReference();
            this.datasourceOperations.executeSelectOverStream(query, new EntityNameLookupRecordConverter(), stream -> results.set(Page.mapped((PageToken)pageToken, (Stream)stream, Function.identity(), EntityIdToken::fromEntity)));
            return (Page)results.get();
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to retrieve polaris entities due to %s", e.getMessage()), e);
        }
    }

    @Nonnull
    public <T> Page<T> listFullEntities(@Nonnull PolarisCallContext callCtx, long catalogId, long parentId, @Nonnull PolarisEntityType entityType, @Nonnull PolarisEntitySubType entitySubType, @Nonnull Predicate<PolarisBaseEntity> entityFilter, @Nonnull Function<PolarisBaseEntity, T> transformer, @Nonnull PageToken pageToken) {
        try {
            QueryGenerator.PreparedQuery query = this.buildEntityQuery(catalogId, parentId, entityType, entitySubType, pageToken, ModelEntity.getAllColumnNames(this.schemaVersion));
            AtomicReference results = new AtomicReference();
            this.datasourceOperations.executeSelectOverStream(query, new ModelEntity(this.schemaVersion), stream -> {
                Stream data = stream.filter(entityFilter);
                results.set(Page.mapped((PageToken)pageToken, data, (Function)transformer, EntityIdToken::fromEntity));
            });
            return (Page)results.get();
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to retrieve polaris entities due to %s", e.getMessage()), e);
        }
    }

    public int lookupEntityGrantRecordsVersion(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId) {
        Map<String, Object> params = Map.of("catalog_id", catalogId, "id", entityId, "realm_id", this.realmId);
        PolarisBaseEntity b = this.getPolarisBaseEntity(QueryGenerator.generateSelectQuery(ModelEntity.getAllColumnNames(this.schemaVersion), "ENTITIES", params));
        return b == null ? 0 : b.getGrantRecordsVersion();
    }

    public PolarisGrantRecord lookupGrantRecord(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId, long granteeCatalogId, long granteeId, int privilegeCode) {
        Map<String, Object> params = Map.of("securable_catalog_id", securableCatalogId, "securable_id", securableId, "grantee_catalog_id", granteeCatalogId, "grantee_id", granteeId, "privilege_code", privilegeCode, "realm_id", this.realmId);
        try {
            List<PolarisGrantRecord> results = this.datasourceOperations.executeSelect(QueryGenerator.generateSelectQuery(ModelGrantRecord.ALL_COLUMNS, "GRANT_RECORDS", params), new ModelGrantRecord());
            if (results.size() > 1) {
                throw new IllegalStateException(String.format("More than one grant record %s for a given Grant record", results.getFirst()));
            }
            if (results.isEmpty()) {
                return null;
            }
            return results.getFirst();
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to retrieve grant record due to %s", e.getMessage()), e);
        }
    }

    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnSecurable(@Nonnull PolarisCallContext callCtx, long securableCatalogId, long securableId) {
        Map<String, Object> params = Map.of("securable_catalog_id", securableCatalogId, "securable_id", securableId, "realm_id", this.realmId);
        try {
            List<PolarisGrantRecord> results = this.datasourceOperations.executeSelect(QueryGenerator.generateSelectQuery(ModelGrantRecord.ALL_COLUMNS, "GRANT_RECORDS", params), new ModelGrantRecord());
            return results == null ? Collections.emptyList() : results;
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to retrieve grant records for securableCatalogId: %s securableId: %s due to %s", securableCatalogId, securableId, e.getMessage()), e);
        }
    }

    @Nonnull
    public List<PolarisGrantRecord> loadAllGrantRecordsOnGrantee(@Nonnull PolarisCallContext callCtx, long granteeCatalogId, long granteeId) {
        Map<String, Object> params = Map.of("grantee_catalog_id", granteeCatalogId, "grantee_id", granteeId, "realm_id", this.realmId);
        try {
            List<PolarisGrantRecord> results = this.datasourceOperations.executeSelect(QueryGenerator.generateSelectQuery(ModelGrantRecord.ALL_COLUMNS, "GRANT_RECORDS", params), new ModelGrantRecord());
            return results == null ? Collections.emptyList() : results;
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to retrieve grant records for granteeCatalogId: %s granteeId: %s due to %s", granteeCatalogId, granteeId, e.getMessage()), e);
        }
    }

    public boolean hasChildren(@Nonnull PolarisCallContext callContext, PolarisEntityType optionalEntityType, long catalogId, long parentId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("realm_id", this.realmId);
        params.put("catalog_id", catalogId);
        params.put("parent_id", parentId);
        if (optionalEntityType != null) {
            params.put("type_code", optionalEntityType.getCode());
        }
        try {
            List<PolarisBaseEntity> results = this.datasourceOperations.executeSelect(QueryGenerator.generateSelectQuery(ModelEntity.getAllColumnNames(this.schemaVersion), "ENTITIES", params), new ModelEntity(this.schemaVersion));
            return results != null && !results.isEmpty();
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to retrieve entities for catalogId: %s due to %s", catalogId, e.getMessage()), e);
        }
    }

    static int loadSchemaVersion(DatasourceOperations datasourceOperations, boolean fallbackOnDoesNotExist) {
        QueryGenerator.PreparedQuery query = QueryGenerator.generateVersionQuery();
        try {
            List<SchemaVersion> schemaVersion = datasourceOperations.executeSelect(query, new SchemaVersion());
            if (schemaVersion == null || schemaVersion.size() != 1) {
                throw new RuntimeException("Failed to retrieve schema version");
            }
            return schemaVersion.getFirst().getValue();
        }
        catch (SQLException e) {
            if (fallbackOnDoesNotExist && datasourceOperations.isRelationDoesNotExist(e)) {
                return SchemaVersion.MINIMUM.getValue();
            }
            LOGGER.error("Failed to load schema version due to {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalStateException("Failed to retrieve schema version", e);
        }
    }

    static boolean entityTableExists(DatasourceOperations datasourceOperations) {
        QueryGenerator.PreparedQuery query = QueryGenerator.generateEntityTableExistQuery();
        try {
            List<PolarisBaseEntity> entities = datasourceOperations.executeSelect(query, new ModelEntity());
            return entities != null && !entities.isEmpty();
        }
        catch (SQLException e) {
            if (datasourceOperations.isRelationDoesNotExist(e)) {
                return false;
            }
            throw new IllegalStateException("Failed to check if Entities table exists", e);
        }
    }

    public <T extends PolarisEntity> Optional<Optional<String>> hasOverlappingSiblings(@Nonnull PolarisCallContext callContext, T entity) {
        if (this.schemaVersion < 2) {
            return Optional.empty();
        }
        if (((LocationBasedEntity)entity).getBaseLocation().chars().filter(ch -> ch == 47).count() > 40L) {
            return Optional.empty();
        }
        QueryGenerator.PreparedQuery query = QueryGenerator.generateOverlapQuery(this.realmId, this.schemaVersion, entity.getCatalogId(), ((LocationBasedEntity)entity).getBaseLocation());
        try {
            List<PolarisBaseEntity> results = this.datasourceOperations.executeSelect(query, new ModelEntity(this.schemaVersion));
            if (!results.isEmpty()) {
                StorageLocation entityLocation = StorageLocation.of((String)((LocationBasedEntity)entity).getBaseLocation());
                for (PolarisBaseEntity result : results) {
                    StorageLocation potentialSiblingLocation = StorageLocation.of((String)((LocationBasedEntity)result).getBaseLocation());
                    if (!entityLocation.isChildOf(potentialSiblingLocation) && !potentialSiblingLocation.isChildOf(entityLocation)) continue;
                    return Optional.of(Optional.of(potentialSiblingLocation.toString()));
                }
            }
            return Optional.of(Optional.empty());
        }
        catch (SQLException e) {
            LOGGER.error("Failed to retrieve location overlap for location {} due to {}", new Object[]{((LocationBasedEntity)entity).getBaseLocation(), e.getMessage(), e});
            throw new RuntimeException(String.format("Failed to retrieve location overlap for location: %s", ((LocationBasedEntity)entity).getBaseLocation()), e);
        }
    }

    @Nullable
    public PolarisPrincipalSecrets loadPrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId) {
        Map<String, Object> params = Map.of("principal_client_id", clientId, "realm_id", this.realmId);
        try {
            List<PolarisPrincipalSecrets> results = this.datasourceOperations.executeSelect(QueryGenerator.generateSelectQuery(ModelPrincipalAuthenticationData.ALL_COLUMNS, "PRINCIPAL_AUTHENTICATION_DATA", params), new ModelPrincipalAuthenticationData());
            return results == null || results.isEmpty() ? null : results.getFirst();
        }
        catch (SQLException e) {
            LOGGER.error("Failed to retrieve principals secrets for client id: {}, due to {}", new Object[]{clientId, e.getMessage(), e});
            throw new RuntimeException(String.format("Failed to retrieve principal secrets for clientId: %s", clientId), e);
        }
    }

    @Nonnull
    public PolarisPrincipalSecrets generateNewPrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String principalName, long principalId) {
        PolarisPrincipalSecrets principalSecrets;
        ModelPrincipalAuthenticationData lookupPrincipalSecrets;
        while ((lookupPrincipalSecrets = ModelPrincipalAuthenticationData.fromPrincipalAuthenticationData(this.loadPrincipalSecrets(callCtx, (principalSecrets = this.secretsGenerator.produceSecrets(principalName, principalId)).getPrincipalClientId()))) != null) {
        }
        lookupPrincipalSecrets = ModelPrincipalAuthenticationData.fromPrincipalAuthenticationData(principalSecrets);
        try {
            List<Object> values = lookupPrincipalSecrets.toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList();
            this.datasourceOperations.executeUpdate(QueryGenerator.generateInsertQuery(ModelPrincipalAuthenticationData.ALL_COLUMNS, "PRINCIPAL_AUTHENTICATION_DATA", values, this.realmId));
        }
        catch (SQLException e) {
            LOGGER.error("Failed to generate new principal secrets for principalId: {}, due to {}", new Object[]{principalId, e.getMessage(), e});
            throw new RuntimeException(String.format("Failed to generate new principal secrets for principalId: %s", principalId), e);
        }
        return principalSecrets;
    }

    @Nullable
    public PolarisPrincipalSecrets storePrincipalSecrets(@Nonnull PolarisCallContext callCtx, long principalId, @Nonnull String resolvedClientId, String customClientSecret) {
        PolarisPrincipalSecrets principalSecrets = new PolarisPrincipalSecrets(principalId, resolvedClientId, customClientSecret);
        try {
            ModelPrincipalAuthenticationData modelPrincipalAuthenticationData = ModelPrincipalAuthenticationData.fromPrincipalAuthenticationData(principalSecrets);
            this.datasourceOperations.executeUpdate(QueryGenerator.generateInsertQuery(ModelPrincipalAuthenticationData.ALL_COLUMNS, "PRINCIPAL_AUTHENTICATION_DATA", modelPrincipalAuthenticationData.toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList(), this.realmId));
        }
        catch (SQLException e) {
            LOGGER.error("Failed to reset PrincipalSecrets  for clientId: {}, due to {}", new Object[]{resolvedClientId, e.getMessage(), e});
            throw new RuntimeException(String.format("Failed to reset PrincipalSecrets for clientId: %s", resolvedClientId), e);
        }
        return principalSecrets;
    }

    @Nullable
    public PolarisPrincipalSecrets rotatePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId, boolean reset, @Nonnull String oldSecretHash) {
        PolarisPrincipalSecrets principalSecrets = this.loadPrincipalSecrets(callCtx, clientId);
        this.diagnostics.checkNotNull((Object)principalSecrets, "cannot_find_secrets", "client_id={} principalId={}", new Object[]{clientId, principalId});
        this.diagnostics.check(principalId == principalSecrets.getPrincipalId(), "principal_id_mismatch", "expectedId={} id={}", new Object[]{principalId, principalSecrets.getPrincipalId()});
        principalSecrets.rotateSecrets(oldSecretHash);
        if (reset) {
            principalSecrets.rotateSecrets(principalSecrets.getMainSecretHash());
        }
        Map<String, Object> params = Map.of("principal_client_id", clientId, "realm_id", this.realmId);
        try {
            ModelPrincipalAuthenticationData modelPrincipalAuthenticationData = ModelPrincipalAuthenticationData.fromPrincipalAuthenticationData(principalSecrets);
            this.datasourceOperations.executeUpdate(QueryGenerator.generateUpdateQuery(ModelPrincipalAuthenticationData.ALL_COLUMNS, "PRINCIPAL_AUTHENTICATION_DATA", modelPrincipalAuthenticationData.toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList(), params));
        }
        catch (SQLException e) {
            LOGGER.error("Failed to rotatePrincipalSecrets  for clientId: {}, due to {}", new Object[]{clientId, e.getMessage(), e});
            throw new RuntimeException(String.format("Failed to rotatePrincipalSecrets for clientId: %s", clientId), e);
        }
        return principalSecrets;
    }

    public void deletePrincipalSecrets(@Nonnull PolarisCallContext callCtx, @Nonnull String clientId, long principalId) {
        Map<String, Object> params = Map.of("principal_client_id", clientId, "principal_id", principalId, "realm_id", this.realmId);
        try {
            this.datasourceOperations.executeUpdate(QueryGenerator.generateDeleteQuery(ModelPrincipalAuthenticationData.ALL_COLUMNS, "PRINCIPAL_AUTHENTICATION_DATA", params));
        }
        catch (SQLException e) {
            LOGGER.error("Failed to delete principalSecrets for clientId: {}, due to {}", new Object[]{clientId, e.getMessage(), e});
            throw new RuntimeException(String.format("Failed to delete principalSecrets for clientId: %s", clientId), e);
        }
    }

    public void writeToPolicyMappingRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record) {
        try {
            this.datasourceOperations.runWithinTransaction(connection -> {
                PolicyType policyType = PolicyType.fromCode((int)record.getPolicyTypeCode());
                Preconditions.checkArgument((policyType != null ? 1 : 0) != 0, (String)"Invalid policy type code: %s", (int)record.getPolicyTypeCode());
                ModelPolicyMappingRecord modelPolicyMappingRecord = ModelPolicyMappingRecord.fromPolicyMappingRecord(record);
                List<Object> values = modelPolicyMappingRecord.toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList();
                QueryGenerator.PreparedQuery insertPolicyMappingQuery = QueryGenerator.generateInsertQuery(ModelPolicyMappingRecord.ALL_COLUMNS, "POLICY_MAPPING_RECORD", values, this.realmId);
                if (policyType.isInheritable()) {
                    return this.handleInheritablePolicy(callCtx, record, insertPolicyMappingQuery, connection);
                }
                this.datasourceOperations.execute(connection, insertPolicyMappingQuery);
                return true;
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to write to policy mapping records due to %s", e.getMessage()), e);
        }
    }

    private boolean handleInheritablePolicy(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record, @Nonnull QueryGenerator.PreparedQuery insertQuery, Connection connection) throws SQLException {
        List<PolarisPolicyMappingRecord> existingRecords = this.loadPoliciesOnTargetByType(callCtx, record.getTargetCatalogId(), record.getTargetId(), record.getPolicyTypeCode());
        if (existingRecords.size() > 1) {
            throw new PolicyMappingAlreadyExistsException(existingRecords.getFirst());
        }
        if (existingRecords.size() == 1) {
            PolarisPolicyMappingRecord existingRecord = existingRecords.getFirst();
            if (existingRecord.getPolicyCatalogId() != record.getPolicyCatalogId() || existingRecord.getPolicyId() != record.getPolicyId()) {
                throw new PolicyMappingAlreadyExistsException(existingRecord);
            }
            Map<String, Object> updateClause = Map.of("target_catalog_id", record.getTargetCatalogId(), "target_id", record.getTargetId(), "policy_type_code", record.getPolicyTypeCode(), "policy_id", record.getPolicyId(), "policy_catalog_id", record.getPolicyCatalogId(), "realm_id", this.realmId);
            ModelPolicyMappingRecord modelPolicyMappingRecord = ModelPolicyMappingRecord.fromPolicyMappingRecord(record);
            QueryGenerator.PreparedQuery updateQuery = QueryGenerator.generateUpdateQuery(ModelPolicyMappingRecord.ALL_COLUMNS, "POLICY_MAPPING_RECORD", modelPolicyMappingRecord.toMap(this.datasourceOperations.getDatabaseType()).values().stream().toList(), updateClause);
            this.datasourceOperations.execute(connection, updateQuery);
        } else {
            this.datasourceOperations.executeUpdate(insertQuery);
        }
        return true;
    }

    public void deleteFromPolicyMappingRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisPolicyMappingRecord record) {
        ModelPolicyMappingRecord modelPolicyMappingRecord = ModelPolicyMappingRecord.fromPolicyMappingRecord(record);
        try {
            Map<String, Object> objectMap = modelPolicyMappingRecord.toMap(this.datasourceOperations.getDatabaseType());
            objectMap.put("realm_id", this.realmId);
            this.datasourceOperations.executeUpdate(QueryGenerator.generateDeleteQuery(ModelPolicyMappingRecord.ALL_COLUMNS, "POLICY_MAPPING_RECORD", objectMap));
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to write to policy records due to %s", e.getMessage()), e);
        }
    }

    public void deleteAllEntityPolicyMappingRecords(@Nonnull PolarisCallContext callCtx, @Nonnull PolarisBaseEntity entity, @Nonnull List<PolarisPolicyMappingRecord> mappingOnTarget, @Nonnull List<PolarisPolicyMappingRecord> mappingOnPolicy) {
        try {
            LinkedHashMap<String, Object> queryParams = new LinkedHashMap<String, Object>();
            if (entity.getType() == PolarisEntityType.POLICY) {
                PolicyEntity policyEntity = PolicyEntity.of((PolarisBaseEntity)entity);
                queryParams.put("policy_type_code", policyEntity.getPolicyTypeCode());
                queryParams.put("policy_catalog_id", policyEntity.getCatalogId());
                queryParams.put("policy_id", policyEntity.getId());
            } else {
                queryParams.put("target_catalog_id", entity.getCatalogId());
                queryParams.put("target_id", entity.getId());
            }
            queryParams.put("realm_id", this.realmId);
            this.datasourceOperations.executeUpdate(QueryGenerator.generateDeleteQuery(ModelPolicyMappingRecord.ALL_COLUMNS, "POLICY_MAPPING_RECORD", queryParams));
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to delete policy mapping records due to %s", e.getMessage()), e);
        }
    }

    @Nullable
    public PolarisPolicyMappingRecord lookupPolicyMappingRecord(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId, int policyTypeCode, long policyCatalogId, long policyId) {
        Map<String, Object> params = Map.of("target_catalog_id", targetCatalogId, "target_id", targetId, "policy_type_code", policyTypeCode, "policy_id", policyId, "policy_catalog_id", policyCatalogId, "realm_id", this.realmId);
        List<PolarisPolicyMappingRecord> results = this.fetchPolicyMappingRecords(QueryGenerator.generateSelectQuery(ModelPolicyMappingRecord.ALL_COLUMNS, "POLICY_MAPPING_RECORD", params));
        Preconditions.checkState((results.size() <= 1 ? 1 : 0) != 0, (Object)"More than one policy mapping records found");
        return results.size() == 1 ? results.getFirst() : null;
    }

    @Nonnull
    public List<PolarisPolicyMappingRecord> loadPoliciesOnTargetByType(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId, int policyTypeCode) {
        Map<String, Object> params = Map.of("target_catalog_id", targetCatalogId, "target_id", targetId, "policy_type_code", policyTypeCode, "realm_id", this.realmId);
        return this.fetchPolicyMappingRecords(QueryGenerator.generateSelectQuery(ModelPolicyMappingRecord.ALL_COLUMNS, "POLICY_MAPPING_RECORD", params));
    }

    @Nonnull
    public List<PolarisPolicyMappingRecord> loadAllPoliciesOnTarget(@Nonnull PolarisCallContext callCtx, long targetCatalogId, long targetId) {
        Map<String, Object> params = Map.of("target_catalog_id", targetCatalogId, "target_id", targetId, "realm_id", this.realmId);
        return this.fetchPolicyMappingRecords(QueryGenerator.generateSelectQuery(ModelPolicyMappingRecord.ALL_COLUMNS, "POLICY_MAPPING_RECORD", params));
    }

    @Nonnull
    public List<PolarisPolicyMappingRecord> loadAllTargetsOnPolicy(@Nonnull PolarisCallContext callCtx, long policyCatalogId, long policyId, int policyTypeCode) {
        Map<String, Object> params = Map.of("policy_type_code", policyTypeCode, "policy_catalog_id", policyCatalogId, "policy_id", policyId, "realm_id", this.realmId);
        return this.fetchPolicyMappingRecords(QueryGenerator.generateSelectQuery(ModelPolicyMappingRecord.ALL_COLUMNS, "POLICY_MAPPING_RECORD", params));
    }

    private List<PolarisPolicyMappingRecord> fetchPolicyMappingRecords(QueryGenerator.PreparedQuery query) {
        try {
            List<PolarisPolicyMappingRecord> results = this.datasourceOperations.executeSelect(query, new ModelPolicyMappingRecord());
            return results == null ? Collections.emptyList() : results;
        }
        catch (SQLException e) {
            throw new RuntimeException(String.format("Failed to retrieve policy mapping records %s", e.getMessage()), e);
        }
    }

    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> createStorageIntegration(@Nonnull PolarisCallContext callCtx, long catalogId, long entityId, PolarisStorageConfigurationInfo polarisStorageConfigurationInfo) {
        return this.storageIntegrationProvider.getStorageIntegrationForConfig(polarisStorageConfigurationInfo);
    }

    public <T extends PolarisStorageConfigurationInfo> void persistStorageIntegrationIfNeeded(@Nonnull PolarisCallContext callContext, @Nonnull PolarisBaseEntity entity, @Nullable PolarisStorageIntegration<T> storageIntegration) {
    }

    @Nullable
    public <T extends PolarisStorageConfigurationInfo> PolarisStorageIntegration<T> loadPolarisStorageIntegration(@Nonnull PolarisCallContext callContext, @Nonnull PolarisBaseEntity entity) {
        PolarisStorageConfigurationInfo storageConfig = BaseMetaStoreManager.extractStorageConfiguration((PolarisDiagnostics)this.diagnostics, (PolarisBaseEntity)entity);
        return this.storageIntegrationProvider.getStorageIntegrationForConfig(storageConfig);
    }

    @FunctionalInterface
    private static interface QueryAction {
        public Integer apply(Connection var1, QueryGenerator.PreparedQuery var2) throws SQLException;
    }
}

