/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.auth;

import org.apache.iceberg.rest.HTTPHeaders;
import org.apache.iceberg.rest.HTTPRequest;
import org.apache.iceberg.rest.ImmutableHTTPRequest;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.rest.auth.ImmutableDefaultAuthSession;
import org.immutables.value.Value;

@Value.Style(redactedMask="****")
@Value.Immutable
public interface DefaultAuthSession
extends AuthSession {
    public HTTPHeaders headers();

    @Override
    default public HTTPRequest authenticate(HTTPRequest request) {
        HTTPHeaders headers = request.headers().putIfAbsent(this.headers());
        return headers.equals(request.headers()) ? request : ImmutableHTTPRequest.builder().from(request).headers(headers).build();
    }

    @Override
    default public void close() {
    }

    public static DefaultAuthSession of(HTTPHeaders headers) {
        return ImmutableDefaultAuthSession.builder().headers(headers).build();
    }
}

