/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.datastructure.pattern.PipePattern;

public class UnionPipePattern
extends PipePattern {
    private final List<PipePattern> patterns;

    public UnionPipePattern(List<PipePattern> patterns) {
        this.patterns = patterns;
    }

    @Override
    public String getPattern() {
        return this.patterns.stream().map(PipePattern::getPattern).collect(Collectors.joining(","));
    }

    @Override
    public boolean isRoot() {
        return this.patterns.stream().anyMatch(PipePattern::isRoot);
    }

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public boolean isLegal() {
        return this.patterns.stream().allMatch(PipePattern::isLegal);
    }

    @Override
    public boolean coversDb(String db) {
        return this.patterns.stream().anyMatch(p -> p.coversDb(db));
    }

    @Override
    public boolean coversDevice(String device) {
        return this.patterns.stream().anyMatch(p -> p.coversDevice(device));
    }

    @Override
    public boolean mayOverlapWithDb(String db) {
        return this.patterns.stream().anyMatch(p -> p.mayOverlapWithDb(db));
    }

    @Override
    public boolean mayOverlapWithDevice(String device) {
        return this.patterns.stream().anyMatch(p -> p.mayOverlapWithDevice(device));
    }

    @Override
    public boolean matchesMeasurement(String device, String measurement) {
        return this.patterns.stream().anyMatch(p -> p.matchesMeasurement(device, measurement));
    }

    @Override
    public List<PartialPath> getBaseInclusionPaths() {
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        for (PipePattern p : this.patterns) {
            paths.addAll(p.getBaseInclusionPaths());
        }
        return paths;
    }

    public String toString() {
        return "UnionPipePattern{patterns=" + this.patterns + '}';
    }
}

