/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.receiver;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeSinkNonReportTimeConfigurableException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.resource.log.PipeLogger;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeReceiverStatusHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(PipeReceiverStatusHandler.class);
    private static final String NO_PERMISSION = "No permission";
    private static final String UNCLASSIFIED_EXCEPTION = "Unclassified exception";
    private static final String NO_PERMISSION_STR = "No permissions for this operation";
    private final boolean isRetryAllowedWhenConflictOccurs;
    private final long retryMaxMillisWhenConflictOccurs;
    private final boolean shouldRecordIgnoredDataWhenConflictOccurs;
    private final long retryMaxMillisWhenOtherExceptionsOccur;
    private final boolean shouldRecordIgnoredDataWhenOtherExceptionsOccur;
    private final boolean skipIfNoPrivileges;
    private final AtomicLong exceptionFirstEncounteredTime = new AtomicLong(0L);
    private final AtomicBoolean exceptionEventHasBeenRetried = new AtomicBoolean(false);
    private final AtomicReference<String> exceptionRecordedMessage = new AtomicReference<String>("");
    private static final List<Integer> STATUS_PRIORITY = Collections.unmodifiableList(Arrays.asList(TSStatusCode.SUCCESS_STATUS.getStatusCode(), TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode(), TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode(), TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode(), TSStatusCode.PIPE_RECEIVER_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode()));

    public PipeReceiverStatusHandler(boolean isRetryAllowedWhenConflictOccurs, long retryMaxSecondsWhenConflictOccurs, boolean shouldRecordIgnoredDataWhenConflictOccurs, long retryMaxSecondsWhenOtherExceptionsOccur, boolean shouldRecordIgnoredDataWhenOtherExceptionsOccur, boolean skipIfNoPrivileges) {
        this.isRetryAllowedWhenConflictOccurs = isRetryAllowedWhenConflictOccurs;
        this.retryMaxMillisWhenConflictOccurs = retryMaxSecondsWhenConflictOccurs < 0L ? Long.MAX_VALUE : retryMaxSecondsWhenConflictOccurs * 1000L;
        this.shouldRecordIgnoredDataWhenConflictOccurs = shouldRecordIgnoredDataWhenConflictOccurs;
        this.retryMaxMillisWhenOtherExceptionsOccur = retryMaxSecondsWhenOtherExceptionsOccur < 0L ? Long.MAX_VALUE : retryMaxSecondsWhenOtherExceptionsOccur * 1000L;
        this.shouldRecordIgnoredDataWhenOtherExceptionsOccur = shouldRecordIgnoredDataWhenOtherExceptionsOccur;
        this.skipIfNoPrivileges = skipIfNoPrivileges;
    }

    public void handle(TSStatus status, String exceptionMessage, String recordMessage) {
        this.handle(status, exceptionMessage, recordMessage, false);
    }

    public void handle(TSStatus status, @Nullable String exceptionMessage, String recordMessage, boolean log4NoPrivileges) {
        switch (status.getCode()) {
            case 200: 
            case 400: {
                return;
            }
            case 1809: {
                LOGGER.info("Idempotent conflict exception: will be ignored. status: {}", (Object)status);
                return;
            }
            case 1808: {
                PipeLogger.log(arg_0 -> ((Logger)LOGGER).info(arg_0), "Temporary unavailable exception: will retry forever. status: %s", status);
                throw new PipeRuntimeSinkNonReportTimeConfigurableException(exceptionMessage, Long.MAX_VALUE);
            }
            case 1810: 
            case 1815: {
                if (!this.isRetryAllowedWhenConflictOccurs) {
                    LOGGER.warn("User conflict exception: will be ignored because retry is not allowed. event: {}. status: {}", (Object)(this.shouldRecordIgnoredDataWhenConflictOccurs ? recordMessage : "not recorded"), (Object)status);
                    return;
                }
                PipeReceiverStatusHandler pipeReceiverStatusHandler = this;
                synchronized (pipeReceiverStatusHandler) {
                    this.recordExceptionStatusIfNecessary(recordMessage);
                    if (this.exceptionEventHasBeenRetried.get() && System.currentTimeMillis() - this.exceptionFirstEncounteredTime.get() > this.retryMaxMillisWhenConflictOccurs) {
                        LOGGER.warn("User conflict exception: retry timeout. will be ignored. event: {}. status: {}", (Object)(this.shouldRecordIgnoredDataWhenConflictOccurs ? recordMessage : "not recorded"), (Object)status);
                        this.resetExceptionStatus();
                        return;
                    }
                    LOGGER.warn("User conflict exception: will retry {}. status: {}", (Object)(this.retryMaxMillisWhenConflictOccurs == Long.MAX_VALUE ? "forever" : "for at least " + (double)(this.retryMaxMillisWhenConflictOccurs + this.exceptionFirstEncounteredTime.get() - System.currentTimeMillis()) / 1000.0 + " seconds"), (Object)status);
                    this.exceptionEventHasBeenRetried.set(true);
                    throw new PipeRuntimeSinkNonReportTimeConfigurableException(exceptionMessage, status.getCode() == 1815 && PipeConfig.getInstance().isPipeRetryLocallyForParallelOrUserConflict() ? Long.MAX_VALUE : this.retryMaxMillisWhenConflictOccurs);
                }
            }
            case 803: {
                if (this.skipIfNoPrivileges) {
                    if (log4NoPrivileges && LOGGER.isWarnEnabled()) {
                        LOGGER.warn("{}: Skip if no privileges. will be ignored. event: {}. status: {}", new Object[]{PipeReceiverStatusHandler.getNoPermission(true), this.shouldRecordIgnoredDataWhenOtherExceptionsOccur ? recordMessage : "not recorded", status});
                    }
                    return;
                }
                this.handleOtherExceptions(status, exceptionMessage, recordMessage, true);
                break;
            }
            default: {
                if (Objects.nonNull(exceptionMessage) && exceptionMessage.contains(NO_PERMISSION_STR)) {
                    if (this.skipIfNoPrivileges) {
                        if (log4NoPrivileges && LOGGER.isWarnEnabled()) {
                            LOGGER.warn("{}: Skip if no privileges. will be ignored. event: {}. status: {}", new Object[]{PipeReceiverStatusHandler.getNoPermission(true), this.shouldRecordIgnoredDataWhenOtherExceptionsOccur ? recordMessage : "not recorded", status});
                        }
                        return;
                    }
                    this.handleOtherExceptions(status, exceptionMessage, recordMessage, true);
                    break;
                }
                this.handleOtherExceptions(status, exceptionMessage, recordMessage, false);
            }
        }
    }

    private synchronized void handleOtherExceptions(TSStatus status, String exceptionMessage, String recordMessage, boolean noPermission) {
        this.recordExceptionStatusIfNecessary(recordMessage);
        if (this.exceptionEventHasBeenRetried.get() && System.currentTimeMillis() - this.exceptionFirstEncounteredTime.get() > this.retryMaxMillisWhenOtherExceptionsOccur) {
            LOGGER.warn("{}: retry timeout. will be ignored. event: {}. status: {}", new Object[]{PipeReceiverStatusHandler.getNoPermission(noPermission), this.shouldRecordIgnoredDataWhenOtherExceptionsOccur ? recordMessage : "not recorded", status});
            this.resetExceptionStatus();
            return;
        }
        if (this.retryMaxMillisWhenOtherExceptionsOccur == Long.MAX_VALUE) {
            PipeLogger.log(arg_0 -> ((Logger)LOGGER).warn(arg_0), "%s: will retry forever. status: %s", PipeReceiverStatusHandler.getNoPermission(noPermission), status);
        } else {
            LOGGER.warn("{}: will retry for at least {} seconds. status: {}", new Object[]{PipeReceiverStatusHandler.getNoPermission(noPermission), (double)(this.retryMaxMillisWhenOtherExceptionsOccur + this.exceptionFirstEncounteredTime.get() - System.currentTimeMillis()) / 1000.0, status});
        }
        this.exceptionEventHasBeenRetried.set(true);
        throw new PipeRuntimeSinkNonReportTimeConfigurableException(exceptionMessage, this.retryMaxMillisWhenOtherExceptionsOccur);
    }

    private static String getNoPermission(boolean noPermission) {
        return noPermission ? NO_PERMISSION : UNCLASSIFIED_EXCEPTION;
    }

    private void recordExceptionStatusIfNecessary(String message) {
        if (!Objects.equals(this.exceptionRecordedMessage.get(), message)) {
            this.exceptionFirstEncounteredTime.set(System.currentTimeMillis());
            this.exceptionEventHasBeenRetried.set(false);
            this.exceptionRecordedMessage.set(message);
        }
    }

    private void resetExceptionStatus() {
        this.exceptionFirstEncounteredTime.set(0L);
        this.exceptionEventHasBeenRetried.set(false);
        this.exceptionRecordedMessage.set("");
    }

    public static TSStatus getPriorStatus(List<TSStatus> givenStatusList) {
        TSStatus resultStatus = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        for (TSStatus givenStatus : givenStatusList) {
            if (!STATUS_PRIORITY.contains(givenStatus.getCode())) {
                return givenStatus;
            }
            if (STATUS_PRIORITY.indexOf(givenStatus.getCode()) <= STATUS_PRIORITY.indexOf(resultStatus.getCode())) continue;
            resultStatus.setCode(givenStatus.getCode());
        }
        resultStatus.setSubStatus(givenStatusList);
        return resultStatus;
    }

    public static void setLogger(Logger logger) {
        LOGGER = logger;
    }
}

