/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.CacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheEntryGroup;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheSizeComputer;
import org.apache.tsfile.utils.RamUsageEstimator;

public class CacheEntryGroupImpl<SK, V>
implements ICacheEntryGroup<SK, V> {
    private final Map<SK, CacheEntry<SK, V>> cacheEntryMap = new ConcurrentHashMap<SK, CacheEntry<SK, V>>();
    private final ICacheSizeComputer<SK, V> sizeComputer;
    private final AtomicLong memory;

    CacheEntryGroupImpl(ICacheSizeComputer<SK, V> sizeComputer) {
        this.sizeComputer = sizeComputer;
        this.memory = new AtomicLong(0L);
    }

    @Override
    public CacheEntry<SK, V> getCacheEntry(SK secondKey) {
        return secondKey == null ? null : this.cacheEntryMap.get(secondKey);
    }

    @Override
    public Iterator<Map.Entry<SK, CacheEntry<SK, V>>> getAllCacheEntries() {
        return this.cacheEntryMap.entrySet().iterator();
    }

    @Override
    public CacheEntry<SK, V> computeCacheEntry(SK secondKey, Function<AtomicLong, BiFunction<SK, CacheEntry<SK, V>, CacheEntry<SK, V>>> computation) {
        return this.cacheEntryMap.compute(secondKey, computation.apply(this.memory));
    }

    @Override
    public CacheEntry<SK, V> computeCacheEntryIfPresent(SK secondKey, Function<AtomicLong, BiFunction<SK, CacheEntry<SK, V>, CacheEntry<SK, V>>> computation) {
        return this.cacheEntryMap.computeIfPresent(secondKey, computation.apply(this.memory));
    }

    @Override
    public long removeCacheEntry(SK secondKey) {
        CacheEntry<SK, V> result = this.cacheEntryMap.remove(secondKey);
        if (Objects.nonNull(result)) {
            long delta = (long)(this.sizeComputer.computeSecondKeySize(result.getSecondKey()) + this.sizeComputer.computeValueSize(result.getValue())) + RamUsageEstimator.HASHTABLE_RAM_BYTES_PER_ENTRY;
            this.memory.addAndGet(-delta);
            return delta;
        }
        return 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.cacheEntryMap.isEmpty();
    }

    @Override
    public long getMemory() {
        return this.memory.get();
    }

    @Override
    public int getEntriesCount() {
        return this.cacheEntryMap.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEntryGroupImpl that = (CacheEntryGroupImpl)o;
        return Objects.equals(this.cacheEntryMap, that.cacheEntryMap);
    }

    public int hashCode() {
        return this.cacheEntryMap.hashCode();
    }
}

