/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl;

import java.util.function.Function;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.ICacheSizeComputer;

class CacheSizeComputerImpl<SK, V>
implements ICacheSizeComputer<SK, V> {
    private final Function<SK, Integer> secondKeySizeComputer;
    private final Function<V, Integer> valueSizeComputer;

    CacheSizeComputerImpl(Function<SK, Integer> secondKeySizeComputer, Function<V, Integer> valueSizeCompute) {
        this.secondKeySizeComputer = secondKeySizeComputer;
        this.valueSizeComputer = valueSizeCompute;
    }

    @Override
    public int computeSecondKeySize(SK secondKey) {
        return this.secondKeySizeComputer.apply(secondKey);
    }

    @Override
    public int computeValueSize(V value) {
        return this.valueSizeComputer.apply(value);
    }
}

