/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.runtime.IntoProcessException;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractIntoOperator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.RamUsageEstimator;

public class DeviceViewIntoOperator
extends AbstractIntoOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(DeviceViewIntoOperator.class);
    private static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
    private final Map<String, Map<PartialPath, Map<String, InputLocation>>> deviceToTargetPathSourceInputLocationMap;
    private final Map<String, Map<PartialPath, Map<String, TSDataType>>> deviceToTargetPathDataTypeMap;
    private final Map<String, Boolean> targetDeviceToAlignedMap;
    private final Map<String, List<Pair<String, PartialPath>>> deviceToSourceTargetPathPairListMap;
    private final int deviceColumnIndex;
    private String currentDevice;
    private int batchedRowCount = 0;

    public DeviceViewIntoOperator(OperatorContext operatorContext, Operator child, List<TSDataType> inputColumnTypes, Map<String, Map<PartialPath, Map<String, InputLocation>>> deviceToTargetPathSourceInputLocationMap, Map<String, Map<PartialPath, Map<String, TSDataType>>> deviceToTargetPathDataTypeMap, Map<String, Boolean> targetDeviceToAlignedMap, Map<String, List<Pair<String, PartialPath>>> deviceToSourceTargetPathPairListMap, Map<String, InputLocation> sourceColumnToInputLocationMap, ExecutorService intoOperationExecutor, long statementSizePerLine) {
        super(operatorContext, child, inputColumnTypes, intoOperationExecutor, statementSizePerLine, ColumnHeaderConstant.selectIntoAlignByDeviceColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList()));
        this.deviceToTargetPathSourceInputLocationMap = deviceToTargetPathSourceInputLocationMap;
        this.deviceToTargetPathDataTypeMap = deviceToTargetPathDataTypeMap;
        this.targetDeviceToAlignedMap = targetDeviceToAlignedMap;
        this.deviceToSourceTargetPathPairListMap = deviceToSourceTargetPathPairListMap;
        this.deviceColumnIndex = sourceColumnToInputLocationMap.get("Device").getValueColumnIndex();
    }

    @Override
    protected boolean processTsBlock(TsBlock inputTsBlock) {
        if (inputTsBlock == null || inputTsBlock.isEmpty()) {
            return true;
        }
        String device = String.valueOf(inputTsBlock.getValueColumns()[this.deviceColumnIndex].getBinary(0));
        if (!Objects.equals(device, this.currentDevice)) {
            InsertMultiTabletsStatement insertMultiTabletsStatement = this.constructInsertMultiTabletsStatement(false);
            this.updateResultTsBlock();
            if (insertMultiTabletsStatement != null || this.insertTabletStatementGenerators == null) {
                this.insertTabletStatementGenerators = this.constructInsertTabletStatementGeneratorsByDevice(device);
            } else {
                this.insertTabletStatementGenerators.addAll(this.constructInsertTabletStatementGeneratorsByDevice(device));
            }
            this.currentDevice = device;
            if (insertMultiTabletsStatement != null) {
                this.executeInsertMultiTabletsStatement(insertMultiTabletsStatement);
                this.cachedTsBlock = inputTsBlock;
                return false;
            }
        }
        int readIndex = 0;
        while (readIndex < inputTsBlock.getPositionCount()) {
            int lastReadIndex = readIndex;
            if (!this.insertTabletStatementGenerators.isEmpty()) {
                AbstractIntoOperator.InsertTabletStatementGenerator generatorOfCurrentDevice = (AbstractIntoOperator.InsertTabletStatementGenerator)this.insertTabletStatementGenerators.get(this.insertTabletStatementGenerators.size() - 1);
                int rowCountBeforeProcess = generatorOfCurrentDevice.getRowCount();
                lastReadIndex = Math.max(lastReadIndex, generatorOfCurrentDevice.processTsBlock(inputTsBlock, readIndex));
                this.batchedRowCount += generatorOfCurrentDevice.getRowCount() - rowCountBeforeProcess;
            }
            readIndex = lastReadIndex;
            if (!this.insertMultiTabletsInternally(true)) continue;
            this.cachedTsBlock = inputTsBlock.subTsBlock(readIndex);
            return false;
        }
        return true;
    }

    @Override
    protected TsBlock tryToReturnResultTsBlock() {
        InsertMultiTabletsStatement insertMultiTabletsStatement = this.constructInsertMultiTabletsStatement(false);
        this.updateResultTsBlock();
        this.currentDevice = null;
        if (insertMultiTabletsStatement != null) {
            this.executeInsertMultiTabletsStatement(insertMultiTabletsStatement);
            return null;
        }
        this.finished = true;
        return this.resultTsBlockBuilder.build();
    }

    @Override
    protected TsBlock tryToReturnPartialResult() {
        if (this.resultTsBlockBuilder.isFull()) {
            TsBlock res = this.resultTsBlockBuilder.build();
            this.resultTsBlockBuilder.reset();
            return res;
        }
        return null;
    }

    private List<AbstractIntoOperator.InsertTabletStatementGenerator> constructInsertTabletStatementGeneratorsByDevice(String currentDevice) {
        Map<PartialPath, Map<String, InputLocation>> targetPathToSourceInputLocationMap = this.deviceToTargetPathSourceInputLocationMap.get(currentDevice);
        Map<PartialPath, Map<String, TSDataType>> targetPathToDataTypeMap = this.deviceToTargetPathDataTypeMap.get(currentDevice);
        return DeviceViewIntoOperator.constructInsertTabletStatementGenerators(targetPathToSourceInputLocationMap, targetPathToDataTypeMap, this.targetDeviceToAlignedMap, this.typeConvertors, this.maxRowNumberInStatement);
    }

    private void updateResultTsBlock() {
        if (this.currentDevice == null) {
            return;
        }
        TimeColumnBuilder timeColumnBuilder = this.resultTsBlockBuilder.getTimeColumnBuilder();
        ColumnBuilder[] columnBuilders = this.resultTsBlockBuilder.getValueColumnBuilders();
        for (Pair<String, PartialPath> sourceTargetPathPair : this.deviceToSourceTargetPathPairListMap.get(this.currentDevice)) {
            timeColumnBuilder.writeLong(0L);
            columnBuilders[0].writeBinary(new Binary(this.currentDevice, TSFileConfig.STRING_CHARSET));
            columnBuilders[1].writeBinary(new Binary((String)sourceTargetPathPair.left, TSFileConfig.STRING_CHARSET));
            columnBuilders[2].writeBinary(new Binary(((PartialPath)sourceTargetPathPair.right).toString(), TSFileConfig.STRING_CHARSET));
            columnBuilders[3].writeInt(this.findWritten(((PartialPath)sourceTargetPathPair.right).getDevice(), ((PartialPath)sourceTargetPathPair.right).getMeasurement()));
            this.resultTsBlockBuilder.declarePosition();
        }
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.child) + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + this.resultTsBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    protected InsertMultiTabletsStatement constructInsertMultiTabletsStatement(boolean needCheck) {
        if (this.insertTabletStatementGenerators == null) {
            return null;
        }
        boolean hasFullStatement = this.existFullStatement(this.insertTabletStatementGenerators);
        if (needCheck) {
            if (!hasFullStatement) {
                return null;
            }
        } else {
            try {
                if (this.batchedRowCount < CONFIG.getSelectIntoInsertTabletPlanRowLimit() && this.child.hasNextWithTimer()) {
                    return null;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IntoProcessException(e.getMessage());
            }
            catch (Exception e) {
                throw new IntoProcessException(e.getMessage());
            }
        }
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        for (AbstractIntoOperator.InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
            if (generator.isEmpty()) continue;
            insertTabletStatementList.add(generator.constructInsertTabletStatement());
        }
        if (insertTabletStatementList.isEmpty()) {
            return null;
        }
        InsertMultiTabletsStatement insertMultiTabletsStatement = new InsertMultiTabletsStatement();
        insertMultiTabletsStatement.setInsertTabletStatementList(insertTabletStatementList);
        this.batchedRowCount = 0;
        return insertMultiTabletsStatement;
    }

    @Override
    protected int findWritten(String device, String measurement) {
        for (int i = this.insertTabletStatementGenerators.size() - 1; i >= 0; --i) {
            int writtenCountInCurrentGenerator;
            AbstractIntoOperator.InsertTabletStatementGenerator generator = (AbstractIntoOperator.InsertTabletStatementGenerator)this.insertTabletStatementGenerators.get(i);
            if (!Objects.equals(generator.getDevice(), device) || (writtenCountInCurrentGenerator = generator.getWrittenCount(measurement)) < 0) continue;
            return writtenCountInCurrentGenerator;
        }
        return 0;
    }
}

